package ru.yandex.autotests.directapi.agencyclients.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.UsersSteps;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.CoreMatchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


@Aqua.Test
@Features(AgencyClientsFeatures.ADD)
@Description("Проверка интеграции с паспортом")
public class PassportIntegrationTest {
    private static final String AGENCY_LOGIN = AgencyClientsLogins.AGENCY_RUB;
    private static final String EXISTENT_SUBCLIENT = AgencyClientsLogins.AGENCY_RUB_SUBCLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableToCreateSubClients(AGENCY_LOGIN);
    }

    @Test
    public void passportShouldReturnErrorWhenLoginIsOccupied() {
        UsersSteps usersSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(EXISTENT_SUBCLIENT).usersSteps();
        assumeThat("Пользователя с таки логином уже есть в базе",
                usersSteps.getUser(EXISTENT_SUBCLIENT), not(nullValue()));
        api.userSteps.agencyClientsStepsV5().expectErrorOnAgencyClientsAdd(
                new AddRequestMap().withDefault(EXISTENT_SUBCLIENT),
                new Api5Error(5200)
        );
    }
}
