package ru.yandex.autotests.directapi.agencyclients.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AgencyClientsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AgencyClientsFeatures.GET)
@Description("Проверка прав доступа, негативные сценарии")
@RunWith(Parameterized.class)
public class CheckRightsNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public String operatorLogin;

    @Parameterized.Parameter(2)
    public String clientLoginHeader;

    @Parameterized.Parameter(3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0} (operatorLogin = {1}, agencyLogin = {2}, expectedErrorDetail = {4})")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {"В Client-Login может быть только представитель агентства",
                        AgencyClientsLogins.UPD_AGENCY, AgencyClientsLogins.UPD_SUBCLIENT1,
                        error(8000, Api5ErrorDetails.CLIENT_LOGIN_MUST_BE_AGENCY)},
                {"Представитель одного агентства не может получать данные от имени другого агентства",
                        AgencyClientsLogins.AGENCY_RUB_OTHER, AgencyClientsLogins.UPD_AGENCY,
                        error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {"Ограниченый представитель агентства не может получать данныые от имени главного",
                        AgencyClientsLogins.UPD_AGENCY_LIM, AgencyClientsLogins.UPD_AGENCY,
                        error(54, Api5ErrorDetails.NO_RIGHTS_TO_THIS_USER)},
                {"Основной представитель агентства (main) не может получать данныые от имени ограниченного",
                        AgencyClientsLogins.UPD_AGENCY_UNLIM, AgencyClientsLogins.UPD_AGENCY_LIM,
                        error(54, Api5ErrorDetails.NO_RIGHTS_TO_THIS_USER)},
                {"Пользователь с ролью CLIENT не может пользоваться этим сервисом",
                        AgencyClientsLogins.SINGLE_CLIENT, AgencyClientsLogins.UPD_AGENCY,
                        error(54, Api5ErrorDetailsJava.NO_RIGHTS_FOR_AGENCY_SERVICE)},
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        api.as(operatorLogin);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operatorLogin);
    }

    @Test
    public void rolesTest() {
        api.as(operatorLogin).userSteps.agencyClientsStepsV5().expectErrorOnAgencyClientsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AgencyClientsSelectionCriteriaMap())
                        .withFieldNames(AgencyClientFieldEnum.LOGIN),
                clientLoginHeader,
                expectedError
        );
    }

    private static Api5Error error(int code, Api5ErrorDetails detail) {
        return new Api5Error(code, detail);
    }

    private static Api5Error error(int code, Api5ErrorDetailsJava detail) {
        return new Api5Error(code, detail);
    }
}
