package ru.yandex.autotests.directapi.agencyclients.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AgencyClientsFeatures.GET)
@Description("Проверка получения Archived")
@RunWith(Parameterized.class)
public class GetArchivedTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public String operatorLogin;

    @Parameterized.Parameter(2)
    public String agencyLogin;

    @Parameterized.Parameter(3)
    public String subclientLogin;

    @Parameterized.Parameter(4)
    public List<Object> expectedResult;

    @Parameterized.Parameters(name = "{0} {3}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"не заархивированный субклиент, запрос от агентства",
                        AgencyClientsLogins.AGENCY_RUB,
                        AgencyClientsLogins.AGENCY_RUB,
                        AgencyClientsLogins.AGENCY_RUB_SUBCLIENT,
                        Collections.singletonList(new ClientGetItemMap().withArchived(YesNoEnum.NO).getBean())},
                {"заархивированный субклиент, запрос от агентства",
                        AgencyClientsLogins.AGENCY_RUB,
                        AgencyClientsLogins.AGENCY_RUB,
                        AgencyClientsLogins.AGENCY_RUB_SUBCLIENT_ARCHIVED,
                        Collections.singletonList(new ClientGetItemMap().withArchived(YesNoEnum.YES).getBean())},
                {"не заархивированный субклиент, запрос от супера",
                        Logins.SUPER_READER,
                        AgencyClientsLogins.AGENCY_RUB,
                        AgencyClientsLogins.AGENCY_RUB_SUBCLIENT,
                        Collections.singletonList(new ClientGetItemMap().withArchived(YesNoEnum.NO).getBean())},
                {"заархивированный субклиент, запрос от супера",
                        Logins.SUPER_READER,
                        AgencyClientsLogins.AGENCY_RUB,
                        AgencyClientsLogins.AGENCY_RUB_SUBCLIENT_ARCHIVED,
                        Collections.singletonList(new ClientGetItemMap().withArchived(YesNoEnum.YES).getBean())},
                {"не заархивированный субклиент, запрос от представителя по работе с клиентами",
                        AgencyClientsLogins.AGENCY_RUB_REP1,
                        AgencyClientsLogins.AGENCY_RUB_REP1,
                        AgencyClientsLogins.AGENCY_RUB_SUBCLIENT,
                        Collections.singletonList(new ClientGetItemMap().withArchived(YesNoEnum.NO).getBean())},
                {"заархивированный субклиент, запрос от представителя по работе с клиентами",
                        AgencyClientsLogins.AGENCY_RUB_REP1,
                        AgencyClientsLogins.AGENCY_RUB_REP1,
                        AgencyClientsLogins.AGENCY_RUB_SUBCLIENT_ARCHIVED,
                        Collections.singletonList(new ClientGetItemMap().withArchived(YesNoEnum.YES).getBean())},
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AgencyClientsLogins.AGENCY_RUB);
    }

    @Test
    public void getArchivedTest() {
        GetResponse getResponse = api.as(operatorLogin).userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(subclientLogin)
                        .withFieldNames(AgencyClientFieldEnum.ARCHIVED),
                agencyLogin
        );

        assertThat("полученные значения совпадают с ожидаемыми", getResponse.getClients(),
                beanDifferV5(expectedResult));
    }
}
