package ru.yandex.autotests.directapi.agencyclients.get;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient.NotifyCashback2JSONRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.ClientFakeInfo;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.math.RoundingMode.DOWN;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins.AGENCY_RUB;
import static ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins.AGENCY_RUB_SUBCLIENT;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AgencyClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-128511")
@Description("Проверки получения поля Bonuses")
public class GetBonusesTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void init() {
        String client = AGENCY_RUB_SUBCLIENT;
        ClientFakeInfo fakeInfo = api.userSteps.clientFakeSteps().getClientData(client);
        NotifyCashback2JSONRequest request = new NotifyCashback2JSONRequest()
                .withClientID(Long.valueOf(fakeInfo.getClientID()))
                .withBalanceCurrency(Currency.RUB.value())
                .withServiceId(7)
                .withCashbackBonus(BigDecimal.ZERO)
                .withCashbackConsumedBonus(BigDecimal.ZERO);
        log.info("Вызываем метод NotifyClientCashback - сбросим значение ожидающего кешбэка клиенту " + client);
        api.userSteps.getDarkSideSteps().getBalanceClientNotifyCashbackJsonSteps().notifyCashbackNoErrors(request);
    }

    @Test
    public void getBonuses_noCashback() {
        GetResponse response = api.as(AGENCY_RUB).userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(AGENCY_RUB_SUBCLIENT)
                        .withFieldNames(AgencyClientFieldEnum.BONUSES));

        assertThat("У клиента ненулевой ожидающий кешбэк",
                response.getClients().get(0).getBonuses().getAwaitingBonus(),
                equalTo(0L));
    }

    @Test
    public void getBonuses() {
        String client = AGENCY_RUB_SUBCLIENT;
        ClientFakeInfo fakeInfo = api.userSteps.clientFakeSteps().getClientData(client);
        NotifyCashback2JSONRequest request = new NotifyCashback2JSONRequest()
                .withClientID(Long.valueOf(fakeInfo.getClientID()))
                .withBalanceCurrency(Currency.RUB.value())
                .withServiceId(7)
                .withCashbackBonus(BigDecimal.TEN)
                .withCashbackConsumedBonus(BigDecimal.ZERO);
        log.info("Вызываем метод NotifyClientCashback - выставим значение ожидающего кешбэка клиенту " + client);
        api.userSteps.getDarkSideSteps().getBalanceClientNotifyCashbackJsonSteps().notifyCashbackNoErrors(request);

        GetResponse response = api.as(AGENCY_RUB).userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(client)
                        .withFieldNames(AgencyClientFieldEnum.BONUSES));

        assertThat("У клиента неожиданный кешбэк",
                response.getClients().get(0).getBonuses().getAwaitingBonus(),
                equalTo(10_000_000L));
    }
}
