package ru.yandex.autotests.directapi.agencyclients.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AgencyClientsFeatures.GET)
@Description("Проверка допустимых значений FieldNames")
@RunWith(Parameterized.class)
public class GetFieldNamesValidationTest {

    private static final String AGENCY_LOGIN = AgencyClientsLogins.AGENCY_RUB;
    private static final String SUBCLIENT_LOGIN = AgencyClientsLogins.AGENCY_RUB_SUBCLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter
    public ProtocolType protocolType;

    @Parameterized.Parameters(name = "Протокол - {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP}
        });
    }

    @BeforeClass
    @Step("Подготовка тестовых данных")
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_LOGIN);
    }

    @Test
    public void fieldNamesTest() {
        api = api.protocol(protocolType).as(AGENCY_LOGIN);

        GetResponse response = api.userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(SUBCLIENT_LOGIN)
                        .withFieldNames(AgencyClientFieldEnum.values()));

        assumeThat("полученный список с данными 1 клиента", response.getClients(), hasSize(1));

        // NB: проверяем что в объекте из ответа сервиса есть все запрошенные поля, значение полей в данном случае не важны
        BeanCompareStrategy strategy = new BeanCompareStrategy()
                .putFieldMatcher(ClientGetItemMap.LOGIN, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.CLIENT_ID, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.CREATED_AT, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.OVERDRAFT_SUM_AVAILABLE, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.CURRENCY, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.VAT_RATE, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.ACCOUNT_QUALITY, not(nullValue())) // NB: хак, т.к. тут объект JAXB
                .putFieldMatcher(ClientGetItemMap.ARCHIVED, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.NOTIFICATION, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.SETTINGS, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.RESTRICTIONS, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.GRANTS, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.REPRESENTATIVES, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.TYPE, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.COUNTRY_ID, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.PHONE, not(nullValue()))
                .putFieldMatcher(ClientGetItemMap.CLIENT_INFO, not(nullValue()));

        assertThat("объект в ответе содержит запрошенные поля", response.getClients().toArray(),
                IsApiBeanCollectionContaining.hasItems(
                        beanEquals(new ClientGetItemMap().getBean()).accordingStrategy(strategy)));
    }
}
