package ru.yandex.autotests.directapi.agencyclients.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.ClientGetItem;
import com.yandex.direct.api.v5.generalclients.GrantGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.GrantGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.yandex.direct.api.v5.generalclients.PrivilegeEnum.EDIT_CAMPAIGNS;
import static com.yandex.direct.api.v5.generalclients.PrivilegeEnum.IMPORT_XLS;
import static com.yandex.direct.api.v5.generalclients.PrivilegeEnum.TRANSFER_MONEY;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AgencyClientsFeatures.GET)
@Description("Проверка получения Grants")
@RunWith(Parameterized.class)
public class GetGrantsTest {
    private static final String AGENCY_NAME = "Тестовое агентство для API5 AgencyClients";
    private static final String SUBCLIENT_LOGIN = AgencyClientsLogins.AGENCY_RUB_SUBCLIENT;
    private static final String SUBCLIENT1_LOGIN = AgencyClientsLogins.AGENCY_RUB_SUBCLIENT1;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter
    public String agencyRepLogin;

    @Parameterized.Parameter(1)
    public List<Object> expectedResult;


    @Parameterized.Parameters(name = "Логин представителя агентства - {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {AgencyClientsLogins.AGENCY_RUB, Arrays.asList(
                        new ClientGetItemMap().withGrants(
                                new GrantGetItemMap(AGENCY_NAME, EDIT_CAMPAIGNS, YesNoEnum.YES),
                                new GrantGetItemMap(AGENCY_NAME, IMPORT_XLS, YesNoEnum.YES),
                                new GrantGetItemMap(AGENCY_NAME, TRANSFER_MONEY, YesNoEnum.YES)
                        ).getBean(),
                        new ClientGetItemMap().withGrants(
                                new GrantGetItemMap(AGENCY_NAME, EDIT_CAMPAIGNS, YesNoEnum.NO),
                                new GrantGetItemMap(AGENCY_NAME, IMPORT_XLS, YesNoEnum.NO),
                                new GrantGetItemMap(AGENCY_NAME, TRANSFER_MONEY, YesNoEnum.NO)
                        ).getBean()
                )},
                {AgencyClientsLogins.AGENCY_RUB_REP1, Collections.singletonList(
                        new ClientGetItemMap().withGrants(
                                new GrantGetItemMap(AGENCY_NAME, EDIT_CAMPAIGNS, YesNoEnum.YES),
                                new GrantGetItemMap(AGENCY_NAME, IMPORT_XLS, YesNoEnum.YES),
                                new GrantGetItemMap(AGENCY_NAME, TRANSFER_MONEY, YesNoEnum.YES)
                        ).getBean()
                )}
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void clear() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agencyRepLogin);
    }

    @Test
    public void getGrantsTest() {
        GetResponse getResponse = api.as(agencyRepLogin).userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(SUBCLIENT_LOGIN, SUBCLIENT1_LOGIN)
                        .withFieldNames(AgencyClientFieldEnum.GRANTS));

        List<ClientGetItem> actualResult = getResponse.getClients();

        actualResult.forEach(e -> e.getGrants().sort(Comparator.comparing(GrantGetItem::getPrivilege)));

        expectedResult.forEach(e -> ((ClientGetItem) e).getGrants().sort(
                Comparator.comparing(GrantGetItem::getPrivilege)));

        assertThat("полученные значения совпадают с ожидаемыми", actualResult, beanDifferV5(expectedResult));
    }
}
