package ru.yandex.autotests.directapi.agencyclients.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.AgencyClientsSelectionCriteria;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AgencyClientsFeatures.GET)
@Description("Проверка для (суб)клиента, на которого у агентства нет прав")
@RunWith(Parameterized.class)
public class GetNotAgencyClientsNegativeTest {

    private static final String AGENCY_LOGIN = AgencyClientsLogins.AGENCY_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"субклиент другого агентства", AgencyClientsLogins.OTHER_AGENCY_SUBCLIENT},
                {"свободный клиент", AgencyClientsLogins.SINGLE_CLIENT}
        });
    }

    @Before
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_LOGIN);
    }

    @Test
    public void test() {
        AgencyClientsSelectionCriteria selectionCriteria = new AgencyClientsSelectionCriteria();
        selectionCriteria.setLogins(Collections.singletonList(login));

        GetResponse getResponse = api.userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(login).withFieldNames(AgencyClientFieldEnum.CLIENT_ID));

        assertThat("не получили данные субклиента", getResponse.getClients(), empty());
    }

}
