package ru.yandex.autotests.directapi.agencyclients.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.EmailSubscriptionEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersSendaccnews;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersSendnews;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersSendwarn;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersRecord;
import ru.yandex.autotests.direct.db.steps.UsersSteps;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.EmailSubscriptionItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AgencyClientsFeatures.GET)
@Description("Проверка воможных значений поля Notification.EmailSubscriptions")
@RunWith(Parameterized.class)
public class GetNotificationEmailSubscriptionsTest {
    private static final String AGENCY_LOGIN = AgencyClientsLogins.AGENCY_RUB;
    private static final String SUBCLIENT_LOGIN = AgencyClientsLogins.AGENCY_RUB_SUBCLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public UsersSendnews sendNews;

    @Parameterized.Parameter(1)
    public UsersSendaccnews sendAccNews;

    @Parameterized.Parameter(2)
    public UsersSendwarn sendWarn;

    @Parameterized.Parameter(3)
    public List<Object> expectedEmailSubscriptions;

    @Parameterized.Parameters(name = "isSendNews = {0}, isSendAccNews = {1}, isSendWarn = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {UsersSendnews.No, UsersSendaccnews.No, UsersSendwarn.No, Arrays.asList(
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS, YesNoEnum.NO)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS, YesNoEnum.NO)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_POSITION_CHANGES, YesNoEnum.NO)
                                .getBean()
                )},
                {UsersSendnews.Yes, UsersSendaccnews.No, UsersSendwarn.No, Arrays.asList(
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS, YesNoEnum.YES)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS, YesNoEnum.NO)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_POSITION_CHANGES, YesNoEnum.NO)
                                .getBean()
                )},
                {UsersSendnews.No, UsersSendaccnews.Yes, UsersSendwarn.No, Arrays.asList(
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS, YesNoEnum.NO)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS, YesNoEnum.YES)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_POSITION_CHANGES, YesNoEnum.NO)
                                .getBean()
                )},
                {UsersSendnews.No, UsersSendaccnews.No, UsersSendwarn.Yes, Arrays.asList(
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS, YesNoEnum.NO)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS, YesNoEnum.NO)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_POSITION_CHANGES, YesNoEnum.YES)
                                .getBean()
                )},
                {UsersSendnews.Yes, UsersSendaccnews.Yes, UsersSendwarn.No, Arrays.asList(
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS, YesNoEnum.YES)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS, YesNoEnum.YES)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_POSITION_CHANGES, YesNoEnum.NO)
                                .getBean()
                )},
                {UsersSendnews.Yes, UsersSendaccnews.No, UsersSendwarn.Yes, Arrays.asList(
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS, YesNoEnum.YES)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS, YesNoEnum.NO)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_POSITION_CHANGES, YesNoEnum.YES)
                                .getBean()
                )},
                {UsersSendnews.No, UsersSendaccnews.Yes, UsersSendwarn.Yes, Arrays.asList(
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS, YesNoEnum.NO)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS, YesNoEnum.YES)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_POSITION_CHANGES, YesNoEnum.YES)
                                .getBean()
                )},
                {UsersSendnews.Yes, UsersSendaccnews.Yes, UsersSendwarn.Yes, Arrays.asList(
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS, YesNoEnum.YES)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS, YesNoEnum.YES)
                                .getBean(),
                        new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_POSITION_CHANGES, YesNoEnum.YES)
                                .getBean()
                )}
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        // Изменить значения подписок
        UsersSteps usersSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(SUBCLIENT_LOGIN).usersSteps();

        UsersRecord usersRecord = usersSteps.getUser(SUBCLIENT_LOGIN);

        usersRecord.setSendnews(sendNews);
        usersRecord.setSendaccnews(sendAccNews);
        usersRecord.setSendwarn(sendWarn);

        usersSteps.updateUsers(usersRecord);
    }

    @Test
    public void getEmailSubscriptionsTest() {
        // Запросить подписки
        GetResponse response = api.userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(SUBCLIENT_LOGIN)
                        .withFieldNames(AgencyClientFieldEnum.NOTIFICATION));

        assumeThat("полученный список с данными 1 клиента", response.getClients(), hasSize(1));

        assertThat("полученные подписки совпадают с ожидаемыми",
                response.getClients().get(0).getNotification().getEmailSubscriptions(),
                beanDifferV5(expectedEmailSubscriptions));
    }
}
