package ru.yandex.autotests.directapi.agencyclients.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import com.yandex.direct.api.v5.general.LangEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AgencyClientsFeatures.GET)
@Description("Проверка допустимых значений Notification.Lang")
@RunWith(Parameterized.class)
public class GetNotificationLangTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter
    public String agencyLogin;

    @Parameterized.Parameter(1)
    public String subclientLogin;

    @Parameterized.Parameter(2)
    public String dbLang;

    @Parameterized.Parameter(3)
    public LangEnum apiLang;

    private UsersRecord usersRecord;

    @Parameterized.Parameters(name = "Агентство - {0}, субклиент - {1}, db lang - {2}, api lang - {3}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {AgencyClientsLogins.AGENCY_RUB, AgencyClientsLogins.AGENCY_RUB_SUBCLIENT, "ru", LangEnum.RU},
                {AgencyClientsLogins.AGENCY_UAH, AgencyClientsLogins.AGENCY_UAH_SUBCLIENT, "ua", LangEnum.UK},
                {AgencyClientsLogins.AGENCY_EUR, AgencyClientsLogins.AGENCY_EUR_SUBCLIENT, "en", LangEnum.EN},
                {AgencyClientsLogins.AGENCY_TRY, AgencyClientsLogins.AGENCY_TRY_SUBCLIENT, "tr", LangEnum.TR}
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agencyLogin);

        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(subclientLogin);
        usersRecord = dbSteps.usersSteps().getUser(subclientLogin);
    }

    @Test
    public void getNotificationLangTest() {
        assumeThat("поле users.lang в БД совпадает с желаемым", usersRecord.getLang(), equalTo(dbLang));

        GetResponse response = api.as(agencyLogin).userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(subclientLogin)
                        .withFieldNames(AgencyClientFieldEnum.NOTIFICATION));

        assumeThat("полученный список с данными 1 клиента", response.getClients(), hasSize(1));

        assertThat("полученные поля совпадают с ожидаемыми",
                response.getClients().get(0).getNotification().getLang(), equalTo(apiLang));
    }
}
