package ru.yandex.autotests.directapi.agencyclients.get;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import com.yandex.direct.api.v5.general.RepresentativeRoleEnum;
import com.yandex.direct.api.v5.generalclients.ClientGetItem;
import com.yandex.direct.api.v5.generalclients.Representative;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.RepresentativeMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AgencyClientsFeatures.GET)
@Description("Проверка получения Representatives")
public class GetRepresentativesTest {
    private static final String EMAIL_SUFFIX = "@yandex.ru";
    private static final String AGENCY_LOGIN = AgencyClientsLogins.AGENCY_RUB;
    private static final String SUBCLIENT1_LOGIN = AgencyClientsLogins.AGENCY_RUB_SUBCLIENT;
    private static final String SUBCLIENT1_REP1_LOGIN = AgencyClientsLogins.AGENCY_RUB_SUBCLIENT_REP;
    private static final String SUBCLIENT1_REP2_LOGIN = AgencyClientsLogins.AGENCY_RUB_SUBCLIENT_REP1;
    private static final String SUBCLIENT2_LOGIN = AgencyClientsLogins.AGENCY_RUB_SUBCLIENT1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private List<Object> expectedResult;

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        expectedResult = Arrays.asList(
                new ClientGetItemMap().withRepresentatives(
                        new RepresentativeMap()
                                .withLogin(SUBCLIENT1_LOGIN)
                                .withEmail(SUBCLIENT1_LOGIN.concat(EMAIL_SUFFIX))
                                .withRole(RepresentativeRoleEnum.CHIEF),
                        new RepresentativeMap()
                                .withLogin(SUBCLIENT1_REP1_LOGIN)
                                .withEmail(SUBCLIENT1_REP1_LOGIN.concat(EMAIL_SUFFIX))
                                .withRole(RepresentativeRoleEnum.DELEGATE),
                        new RepresentativeMap()
                                .withLogin(SUBCLIENT1_REP2_LOGIN)
                                .withEmail(SUBCLIENT1_REP2_LOGIN.concat(EMAIL_SUFFIX))
                                .withRole(RepresentativeRoleEnum.DELEGATE)
                ).getBean(),
                new ClientGetItemMap().withRepresentatives(
                        new RepresentativeMap()
                                .withLogin(SUBCLIENT2_LOGIN)
                                .withEmail(SUBCLIENT2_LOGIN.concat(EMAIL_SUFFIX))
                                .withRole(RepresentativeRoleEnum.CHIEF)
                ).getBean()
        );

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_LOGIN);
    }

    @Test
    public void getRepresentativesTest() {
        GetResponse getResponse = api.userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(SUBCLIENT1_LOGIN, SUBCLIENT2_LOGIN)
                        .withFieldNames(AgencyClientFieldEnum.REPRESENTATIVES));

        List<ClientGetItem> actualResult = getResponse.getClients();

        actualResult.forEach(e -> e.getRepresentatives().sort(Comparator.comparing(Representative::getLogin)));

        expectedResult.forEach(
                e -> ((ClientGetItem) e).getRepresentatives().sort(Comparator.comparing(Representative::getLogin)));

        assertThat("полученное значение совпадает с ожидаемым", actualResult, beanDifferV5(expectedResult));
    }
}
