package ru.yandex.autotests.directapi.agencyclients.get;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AgencyClientsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.hasItems;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.hasProperty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AgencyClientsFeatures.GET)
@Description("Проверка SelectionCriteria.Archived")
public class GetSelectionCriteriaArchivedTest {
    private static final String AGENCY_LOGIN = AgencyClientsLogins.AGENCY_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Step("Подгтовка тестовых данных")
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_LOGIN);
    }

    @Test
    public void getSelectionCriteriaArchivedUnspecifiedTest() {
        GetResponse getResponse = api.userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSelectionCriteria(new AgencyClientsSelectionCriteriaMap())
                        .withFieldNames(AgencyClientFieldEnum.LOGIN));

        assertThat("получены архивные и неархивные пользователи", getResponse.getClients(),
                hasItems(
                        hasProperty("login", equalTo(AgencyClientsLogins.AGENCY_RUB_SUBCLIENT)),
                        hasProperty("login", equalTo(AgencyClientsLogins.AGENCY_RUB_SUBCLIENT_ARCHIVED))
                ));
    }

    @Test
    public void getSelectionCriteriaArchivedYes() {
        GetResponse getResponse = api.userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AgencyClientsSelectionCriteriaMap().withArchived(YesNoEnum.YES))
                        .withFieldNames(AgencyClientFieldEnum.LOGIN));

        assertThat("получен только архивный клиент", getResponse.getClients(),
                allOf(
                        hasItem(hasProperty("login", equalTo(AgencyClientsLogins.AGENCY_RUB_SUBCLIENT_ARCHIVED))),
                        not(hasItem(hasProperty("login", equalTo(AgencyClientsLogins.AGENCY_RUB_SUBCLIENT))))
                )
        );
    }

    @Test
    public void getSelectionCriteriaArchivedNo() {
        GetResponse getResponse = api.userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AgencyClientsSelectionCriteriaMap().withArchived(YesNoEnum.NO))
                        .withFieldNames(AgencyClientFieldEnum.LOGIN));

        assertThat("получен только неархивный клиент", getResponse.getClients(),
                allOf(
                        hasItem(hasProperty("login", equalTo(AgencyClientsLogins.AGENCY_RUB_SUBCLIENT))),
                        not(hasItem(hasProperty("login", equalTo(AgencyClientsLogins.AGENCY_RUB_SUBCLIENT_ARCHIVED))))
                )
        );
    }
}
