package ru.yandex.autotests.directapi.agencyclients.update;


import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.UsersSteps;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AgencyClientUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.agencyclients.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.directapi.model.Logins.AGENCY_KZT;
import static ru.yandex.autotests.directapi.model.Logins.AGENCY_RUB;
import static ru.yandex.autotests.directapi.model.Logins.SUBCLIENT_KZT;
import static ru.yandex.autotests.directapi.model.Logins.SUBCLIENT_RUB;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AgencyClientsFeatures.ADD)
@Description("Проверка того, что для уже существующих KZT сабклиентов не выставляется clients_options.is_using_quasi_currency в 1")
@Issue("https://st.yandex-team.ru/DIRECT-73266")
@RunWith(Parameterized.class)
public class KztSubClientUpdateQuasicurrencyTest {
    private static final String FIO_NEW = "Сакцес Апдейтов";

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String agencyLogin;

    @Parameterized.Parameter(1)
    public String subclientLogin;

    private long subclientId;

    @Before
    public void initTestCase() {
        api.as(agencyLogin).userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
        UsersSteps usersSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(subclientLogin).usersSteps();
        subclientId = usersSteps.getUser(subclientLogin).getClientid();
    }

    @Parameterized.Parameters(name = "agencyLogin: {0}, subclientLogin: {1})")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {AGENCY_RUB, SUBCLIENT_RUB},
                {AGENCY_KZT, SUBCLIENT_KZT}
        });
    }

    @Test
    public void successUpdateFioTest() {
        int origUsingQuasicurrency = api.userSteps.getDirectJooqDbSteps()
                .clientsOptionsSteps().getClientOptions(subclientId).getIsUsingQuasiCurrency();

        api.userSteps.agencyClientsStepsV5().agencyClientsUpdate(
                new UpdateRequestMap().withClients(
                        new AgencyClientUpdateItemMap()
                                .withClientId(subclientId)
                                .withClientInfo(FIO_NEW)),
                agencyLogin
        );
        int newUsingQuasicurrency = api.userSteps.getDirectJooqDbSteps()
                .clientsOptionsSteps().getClientOptions(subclientId).getIsUsingQuasiCurrency();
        assertThat("поле is_using_quasi_currency не поменялось", newUsingQuasicurrency, equalTo(origUsingQuasicurrency));
    }
}
