package ru.yandex.autotests.directapi.agencyclients.update;

import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import com.yandex.direct.api.v5.agencyclients.UpdateResponse;
import com.yandex.direct.api.v5.general.LangEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingGetEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingUpdateEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.UsersSteps;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AgencyClientUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.agencyclients.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.clients.ClientSettingUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.clients.NotificationUpdateMap;
import ru.yandex.autotests.directapi.model.api5.general.ActionResultBaseMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientSettingGetItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.EmailSubscriptionItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.NotificationGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.yandex.direct.api.v5.generalclients.EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS;
import static com.yandex.direct.api.v5.generalclients.EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS;
import static com.yandex.direct.api.v5.generalclients.EmailSubscriptionEnum.TRACK_POSITION_CHANGES;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.hasProperty;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/DIRECT-69110
 */
@Aqua.Test
@Features(AgencyClientsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-64387")
@Description("Проверка успешного обновления")
public class UpdateFullPositiveTest {
    public static final String SUBCLIENT_LOGIN = AgencyClientsLogins.UPD_SUBCLIENT2;
    public static final String AGENCY_LOGIN = AgencyClientsLogins.UPD_AGENCY;

    public static final String PHONE_BEFORE = "+72223334455";
    public static final String EMAIL_BEFORE = "xxx@xxx.xxx";
    public static final LangEnum LANG_BEFORE = LangEnum.TR;
    public static final YesNoEnum ALL_EMAIL_SUBSCRIPTION_VALUE_BEFORE = YesNoEnum.NO;
    public static final YesNoEnum ALL_SETTINGS_BEFORE = YesNoEnum.NO;

    public static final String PHONE_AFTER = "+70001001020";
    public static final String EMAIL_AFTER = "eee@eee.ee";
    public static final LangEnum LANG_AFTER = LangEnum.RU;
    public static final YesNoEnum ALL_EMAIL_SUBSCRIPTION_VALUE_AFTER = YesNoEnum.YES;
    public static final YesNoEnum ALL_SETTINGS_AFTER = YesNoEnum.YES;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private UsersSteps usersSteps;
    private Long subClientId;

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        usersSteps = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(SUBCLIENT_LOGIN).usersSteps();
        subClientId = usersSteps.getUser(SUBCLIENT_LOGIN).getClientid();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_LOGIN);
    }

    @Test
    public void successUpdateAll() {
        // в этом тесте не проверется успешность обновления Grants и ClientInfo, т.к. это проверяется
        // в других тестах рядом
        updateToBeforeState();
        GetResponse getResponse = api.userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(SUBCLIENT_LOGIN)
                        .withFieldNames(AgencyClientFieldEnum.PHONE, AgencyClientFieldEnum.NOTIFICATION,
                                AgencyClientFieldEnum.SETTINGS)
        );
        assertThat("удалось установить начальное состояние свойств субклиента",
                getResponse.getClients(), contains(
                        allOf(
                                hasProperty(ClientGetItemMap.PHONE, equalTo(PHONE_BEFORE)),
                                hasProperty(ClientGetItemMap.NOTIFICATION, allOf(
                                        hasProperty(NotificationGetMap.EMAIL, equalTo(EMAIL_BEFORE)),
                                        hasProperty(NotificationGetMap.LANG, equalTo(LANG_BEFORE)),
                                        hasProperty(NotificationGetMap.EMAIL_SUBSCRIPTIONS, containsInAnyOrder(
                                                beanDifferV5(new EmailSubscriptionItemMap(
                                                        RECEIVE_RECOMMENDATIONS,
                                                        ALL_EMAIL_SUBSCRIPTION_VALUE_BEFORE).getBean()),
                                                beanDifferV5(new EmailSubscriptionItemMap(
                                                        TRACK_MANAGED_CAMPAIGNS,
                                                        ALL_EMAIL_SUBSCRIPTION_VALUE_BEFORE).getBean()),
                                                beanDifferV5(new EmailSubscriptionItemMap(
                                                        TRACK_POSITION_CHANGES,
                                                        ALL_EMAIL_SUBSCRIPTION_VALUE_BEFORE).getBean())
                                                )
                                        ))
                                ),
                                hasProperty(ClientGetItemMap.SETTINGS, hasItems(
                                        beanDifferV5(new ClientSettingGetItemMap(
                                                ClientSettingGetEnum.CORRECT_TYPOS_AUTOMATICALLY,
                                                ALL_SETTINGS_BEFORE).getBean()),
                                        beanDifferV5(new ClientSettingGetItemMap(
                                                ClientSettingGetEnum.DISPLAY_STORE_RATING,
                                                ALL_SETTINGS_BEFORE).getBean())
                                ))
                        )
                )
        );

        updateToAfterState();
        getResponse = api.userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap().withSubclientLogins(SUBCLIENT_LOGIN)
                        .withFieldNames(AgencyClientFieldEnum.PHONE, AgencyClientFieldEnum.NOTIFICATION,
                                AgencyClientFieldEnum.SETTINGS)
        );
        assertThat("удалось установить новое состояние свойств субклиента",
                getResponse.getClients(), contains(
                        allOf(
                                hasProperty(ClientGetItemMap.PHONE, equalTo(PHONE_AFTER)),
                                hasProperty(ClientGetItemMap.NOTIFICATION, allOf(
                                        hasProperty(NotificationGetMap.EMAIL, equalTo(EMAIL_AFTER)),
                                        hasProperty(NotificationGetMap.LANG, equalTo(LANG_AFTER)),
                                        hasProperty(NotificationGetMap.EMAIL_SUBSCRIPTIONS, containsInAnyOrder(
                                                beanDifferV5(new EmailSubscriptionItemMap(
                                                        RECEIVE_RECOMMENDATIONS,
                                                        ALL_EMAIL_SUBSCRIPTION_VALUE_AFTER).getBean()),
                                                beanDifferV5(new EmailSubscriptionItemMap(
                                                        TRACK_MANAGED_CAMPAIGNS,
                                                        ALL_EMAIL_SUBSCRIPTION_VALUE_AFTER).getBean()),
                                                beanDifferV5(new EmailSubscriptionItemMap(
                                                        TRACK_POSITION_CHANGES,
                                                        ALL_EMAIL_SUBSCRIPTION_VALUE_AFTER).getBean())
                                                )
                                        ))
                                ),
                                hasProperty(ClientGetItemMap.SETTINGS, hasItems(
                                        beanDifferV5(new ClientSettingGetItemMap(
                                                ClientSettingGetEnum.CORRECT_TYPOS_AUTOMATICALLY,
                                                ALL_SETTINGS_AFTER).getBean()),
                                        beanDifferV5(new ClientSettingGetItemMap(
                                                ClientSettingGetEnum.DISPLAY_STORE_RATING,
                                                ALL_SETTINGS_AFTER).getBean())
                                ))
                        )
                )
        );
    }

    private UpdateResponse updateToBeforeState() {
        UpdateResponse updateResponse = api.as(AGENCY_LOGIN).userSteps.agencyClientsStepsV5().agencyClientsUpdate(
                new UpdateRequestMap().withClients(
                        new AgencyClientUpdateItemMap()
                                .withClientId(subClientId)
                                .withPhone(PHONE_BEFORE)
                                .withNotification(
                                        new NotificationUpdateMap()
                                                .withEmail(EMAIL_BEFORE)
                                                .withLang(LANG_BEFORE)
                                                .withEmailSubscription(
                                                        new EmailSubscriptionItemMap(
                                                                RECEIVE_RECOMMENDATIONS,
                                                                ALL_EMAIL_SUBSCRIPTION_VALUE_BEFORE),
                                                        new EmailSubscriptionItemMap(
                                                                TRACK_MANAGED_CAMPAIGNS,
                                                                ALL_EMAIL_SUBSCRIPTION_VALUE_BEFORE),
                                                        new EmailSubscriptionItemMap(
                                                                TRACK_POSITION_CHANGES,
                                                                ALL_EMAIL_SUBSCRIPTION_VALUE_BEFORE)
                                                )
                                )
                                .withSettings(
                                        new ClientSettingUpdateItemMap(
                                                ClientSettingUpdateEnum.CORRECT_TYPOS_AUTOMATICALLY,
                                                ALL_SETTINGS_BEFORE),
                                        new ClientSettingUpdateItemMap(
                                                ClientSettingUpdateEnum.DISPLAY_STORE_RATING,
                                                ALL_SETTINGS_BEFORE)
                                )
                )
        );
        assertThat("результат обновления не содержит ошибок",
                updateResponse.getUpdateResults(), contains(hasProperty(ActionResultBaseMap.ERRORS, empty())));
        return updateResponse;
    }

    private UpdateResponse updateToAfterState() {
        UpdateResponse updateResponse = api.as(AGENCY_LOGIN).userSteps.agencyClientsStepsV5().agencyClientsUpdate(
                new UpdateRequestMap().withClients(
                        new AgencyClientUpdateItemMap()
                                .withClientId(subClientId)
                                .withPhone(PHONE_AFTER)
                                .withNotification(
                                        new NotificationUpdateMap()
                                                .withEmail(EMAIL_AFTER)
                                                .withLang(LANG_AFTER)
                                                .withEmailSubscription(
                                                        new EmailSubscriptionItemMap(
                                                                RECEIVE_RECOMMENDATIONS,
                                                                ALL_EMAIL_SUBSCRIPTION_VALUE_AFTER),
                                                        new EmailSubscriptionItemMap(
                                                                TRACK_MANAGED_CAMPAIGNS,
                                                                ALL_EMAIL_SUBSCRIPTION_VALUE_AFTER),
                                                        new EmailSubscriptionItemMap(
                                                                TRACK_POSITION_CHANGES,
                                                                ALL_EMAIL_SUBSCRIPTION_VALUE_AFTER)
                                                )
                                )
                                .withSettings(
                                        new ClientSettingUpdateItemMap(
                                                ClientSettingUpdateEnum.CORRECT_TYPOS_AUTOMATICALLY,
                                                ALL_SETTINGS_AFTER),
                                        new ClientSettingUpdateItemMap(
                                                ClientSettingUpdateEnum.DISPLAY_STORE_RATING,
                                                ALL_SETTINGS_AFTER)
                                )
                )
        );
        assertThat("результат обновления не содержит ошибок",
                updateResponse.getUpdateResults(), contains(hasProperty(ActionResultBaseMap.ERRORS, empty())));
        return updateResponse;
    }
}
