package ru.yandex.autotests.directapi.agencyclients.update;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.agencyclients.UpdateResponse;
import com.yandex.direct.api.v5.general.ClientsActionResult;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AgencyClientUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.agencyclients.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ActionResultBaseMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientsActionResultMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.hasProperty;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/DIRECT-69110
 */
@Aqua.Test
@Features(AgencyClientsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-64387")
@Description("Проверка безуспешного обновления")
@RunWith(Parameterized.class)
public class UpdateNegativeTest {
    private static final String FIO_NEW = "Сакцес Апдейтов";

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public String operatorLogin;

    @Parameterized.Parameter(2)
    public String agencyLogin;

    @Parameterized.Parameter(3)
    public String subClientLogin;

    private Long subClientId;

    @Parameterized.Parameters(name = "{0}: operatorLogin {1} agencyLogin {2} subClientLogin {3}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Субклиента другого агентства",
                        AgencyClientsLogins.UPD_AGENCY, null, AgencyClientsLogins.OTHER_AGENCY_SUBCLIENT},
                {"Обычного клиента", AgencyClientsLogins.UPD_AGENCY, null, AgencyClientsLogins.SINGLE_CLIENT},
                {"Представителя агенства",
                        AgencyClientsLogins.UPD_AGENCY, null, AgencyClientsLogins.UPD_AGENCY},
                {"Неограниченный представитель агенства, шефа",
                        AgencyClientsLogins.UPD_AGENCY_UNLIM, null, AgencyClientsLogins.UPD_AGENCY},
                {"Ограниченый представитель, субклиента, которым он не управляет",
                        AgencyClientsLogins.UPD_AGENCY_LIM, null, AgencyClientsLogins.UPD_SUBCLIENT2},
                {"Ограниченый представитель, субклиента, которым он не управляет (оператор -- главный)",
                        AgencyClientsLogins.UPD_AGENCY, AgencyClientsLogins.UPD_AGENCY_LIM,
                        AgencyClientsLogins.UPD_SUBCLIENT2},
                {"Обычного клиента (оператор -- менеджер)",
                        AgencyClientsLogins.MANAGER_DEFAULT, AgencyClientsLogins.UPD_AGENCY,
                        AgencyClientsLogins.SINGLE_CLIENT},
                {"Субклиента другого агентства (оператор -- менеджер)",
                        AgencyClientsLogins.MANAGER_DEFAULT, AgencyClientsLogins.UPD_AGENCY,
                        AgencyClientsLogins.OTHER_AGENCY_SUBCLIENT},
                {"Ограниченый представитель, субклиента, которым он не управляет (оператор -- менеджер)",
                        AgencyClientsLogins.MANAGER_DEFAULT, AgencyClientsLogins.UPD_AGENCY_LIM,
                        AgencyClientsLogins.UPD_SUBCLIENT2},
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        subClientId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(subClientLogin)
                .usersSteps()
                .getUser(subClientLogin)
                .getClientid();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operatorLogin);
    }

    @Test
    public void updateFioShouldReturnsErrorForUpdatedSubclient() {
        UpdateResponse response = api.as(operatorLogin).userSteps.agencyClientsStepsV5().agencyClientsUpdate(
                new UpdateRequestMap().withClients(
                        new AgencyClientUpdateItemMap()
                                .withClientId(subClientId)
                                .withClientInfo(FIO_NEW)),
                agencyLogin
        );

        assertThat("результат содержит ожидаемую ошибку", response.getUpdateResults(), contains(
                hasProperty(ActionResultBaseMap.ERRORS, contains(
                        BeanDifferMatcher.beanDiffer(new Notification(8800).getBean())))
        ));
    }
}
