package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersStatusblocked;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/TESTIRT-10929
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Проверка корректности работы метода при StatusBlocked = Yes у Client-Login")
@Issue("https://st.yandex-team.ru/DIRECT-61921")
@RunWith(Parameterized.class)
public class AddAudienceTargetStatusBlockedTest {
    private static final String CLIENT = AudienceTargetsLogins.BLOCKED_CLIENT1;
    private static final String CLIENT_REP = AudienceTargetsLogins.BLOCKED_REP_CLIENT1;
    private static final String SUBCLIENT = AudienceTargetsLogins.BLOCKED_SUBCLIENT1;
    private static final String SERV_CLIENT = AudienceTargetsLogins.BLOCKED_SERV_CLIENT1;
    private static final String AGENCY = "at-agency-webpages";
    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String SUPER = Logins.SUPER_LOGIN;
    private Long retargetingListsId;
    private int shard;
    private Long adGroupId;
    private UsersRecord user;


    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String loginForCreateData;

    @Parameterized.Parameter(2)
    public String apiUserLogin;

    @Parameterized.Parameter(3)
    public String login;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {

        return Arrays.asList(new Object[][]{
                {"Добавление условий от имени менеджера", MANAGER, MANAGER, SERV_CLIENT},

                {"Добавление условий от имени представителя клиента для клиента", SUPER, CLIENT_REP, CLIENT},

                {"Добавление условий от имени агенства для субклиента", AGENCY, AGENCY, SUBCLIENT}
        });
    }

    @BeforeClass
    public static void clearUnits(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SERV_CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT);
    }

    @Before
    public void addUnitsToClient() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.as(loginForCreateData);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, login);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL).get(0);
        retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId, login);
        user = api.userSteps.getDirectJooqDbSteps().useShard(shard).usersSteps().getUser(login);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).usersSteps().setBlocked(user.getUid(), UsersStatusblocked.Yes);
    }

    @Test
    public void addUsingLogin() {
        api.as(apiUserLogin);
        api.userSteps.audienceTargetsSteps().shouldGetErrorOn(
                ServiceNames.AUDIENCE_TARGETS,
                login,
                Action.ADD,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withRetargetingListId(retargetingListsId)),
                new Api5Error(3000, Api5ErrorDetailsJava.ACCOUNT_BLOCKED)
                        .withMessageFromResource(Api5ErrorMessage.NO_ACCESS_TO_API_JAVA)
        );
    }

    @After
    public void makeStatusBlockedNo(){
        api.userSteps.getDirectJooqDbSteps().useShard(shard).usersSteps().setBlocked(user.getUid(), UsersStatusblocked.No);
    }
}


