package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by buhter on 03/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Проверка добавления с различными AdGroupId")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddAudienceTargetsAdGroupIdTest {
    //DIRECT-58218
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET1;
    private static final String ANOTHER_LOGIN = AudienceTargetsLogins.LOGIN_FOR_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long userListsId;

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(ANOTHER_LOGIN);
        userListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(LOGIN);
    }

    @Parameterized.Parameters(name = "Description - {0}")
    public static Collection data() {
        Long otherClientsCid = api.as(ANOTHER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign();
        Long otherClientsPid = api.userSteps.adGroupsSteps().addDefaultGroup(otherClientsCid);
        Long cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long deletedCid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pidFromDeletedCid = api.userSteps.adGroupsSteps().addDefaultGroup(deletedCid);
        api.userSteps.campaignSteps().campaignsDelete(deletedCid);
        Long archivedCid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pidFromArchivedCid = api.userSteps.adGroupsSteps().addDefaultGroup(archivedCid);
        api.userSteps.campaignSteps().campaignsSuspend(archivedCid);
        api.userSteps.campaignSteps().campaignsArchive(archivedCid);

        Object[][] data = new Object[][]{
                {"Correct adGroupId", pid, ExpectedResult.success()},
                {"Other client's adGroupId", otherClientsPid
                        , ExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND,
                        otherClientsPid))},
                {"Zero adGroupId", 0L
                        , ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                        capitalize(AudienceTargetAddItemMap.AD_GROUP_ID)))},
                {"Negative adGroupId", -1L
                        , ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                        capitalize(AudienceTargetAddItemMap.AD_GROUP_ID)))},
                {"Unexisting adGroupId", pid + 100000
                        , ExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND,
                        pid + 100000))},
                {"AdGroupId from deleted campaign", pidFromDeletedCid
                        , ExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND,
                        pidFromDeletedCid))},
                {"AdGroupId from archived campaign", pidFromArchivedCid
                        , ExpectedResult.errors(new Notification(8300,
                        Api5ErrorDetails.AUDIENCE_TARGETS_FORBIDDEN_TO_ADD_IN_ARCHIVE_CAMPAIGN, archivedCid))},//DIRECT-58364
        };
        return Arrays.asList(data);
    }

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long pid;

    @Parameterized.Parameter(2)
    public ExpectedResult result;

    @Test
    public void addWithAdGroup() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue()))
                , result);
    }
}
