package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.enums.DirectObjectType;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by buhter on 03/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Проверка добавления с различными типами групп")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddAudienceTargetsAdGroupTypesTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long userListsId;
    private Long pid;

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        userListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId, LOGIN);
    }

    @Parameterized.Parameter(0)
    public DirectObjectType type;

    @Parameterized.Parameter(1)
    public ExpectedResult result;

    @Parameterized.Parameters(name = "Description - {0}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {DirectObjectType.TEXT, ExpectedResult.success()},
                {DirectObjectType.DYNAMIC,
                        ExpectedResult.errors(new Notification(6001, Api5ErrorDetailsJava.ADGROUP_TYPE_NOT_SUPPORTED))},
                {DirectObjectType.MOBILE_CONTENT, ExpectedResult.success()},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        Long cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultCampaign(type.getCampaignType());
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, type.getAdGroupType());
    }

    @Test
    public void test() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue()))
                , result);
    }
}
