package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Тесты на проверку округления ставок")
public class AddAudienceTargetsBidRoundingTest {

    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private Long adGroupId;
    private Long userListsId;

    @Before
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, LOGIN);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        userListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId, LOGIN);
    }

    @Test
    public void bidRoundUpTest() {
        List<Long> targetIds = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withRetargetingListId(userListsId)
                                .withContextBid(143845000L)));

        assumeThat("Добавлено одно условие нацеливания", targetIds, hasSize(1));

        Long targetId = targetIds.get(0);

        List<AudienceTargetGetItem> response = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap().withSelectionCriteria(
                        new AudienceTargetSelectionCriteriaMap().withIds(targetId))
                        .withFieldNames(AudienceTargetFieldEnum.CONTEXT_BID));

        assumeThat("Должен вернуться один элемент", response, hasSize(1));

        AudienceTargetGetItem responseItem = response.get(0);

        assertThat("Ставка должна округлиться вверх", responseItem.getContextBid(), is(143850000L));
    }

    @Test
    public void bidRoundDownTest() {
        List<Long> targetIds = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withRetargetingListId(userListsId)
                        .withContextBid(143844999L)));

        assumeThat("Добавлено одно условие нацеливания", targetIds, hasSize(1));

        Long targetId = targetIds.get(0);

        List<AudienceTargetGetItem> response = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap().withSelectionCriteria(
                        new AudienceTargetSelectionCriteriaMap().withIds(targetId))
                        .withFieldNames(AudienceTargetFieldEnum.CONTEXT_BID));

        assumeThat("Должен вернуться один элемент", response, hasSize(1));

        AudienceTargetGetItem responseItem = response.get(0);

        assertThat("Ставка должна округлиться вверх", responseItem.getContextBid(), is(143840000L));
    }
}
