package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.decapitalize;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by buhter on 03/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Проверка граничных значений ContextPrice")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddAudienceTargetsContextBidCurrenciesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private Long pid;
    private Long cid;
    private Long userListsId;

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public Long contextBid;

    @Parameterized.Parameter(2)
    public Notification notification;

    @Parameterized.Parameters(name = "Login - {0}, bid - {1}")
    public static Collection data() {
        String locale = DirectTestRunProperties.getInstance().getDirectAPILocale();
        Object[][] data = new Object[][]{
                {AudienceTargetsLogins.LOGIN_RETARGETING_RUB,
                        MoneyCurrency.get(Currency.RUB).getMinPrice().getPrevious().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.RUB).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.RUB).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_USD,
                        MoneyCurrency.get(Currency.USD).getMinPrice().getPrevious().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.USD).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.USD).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_KZT,
                        MoneyCurrency.get(Currency.KZT).getMinPrice().getPrevious().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.KZT).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.KZT).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_EUR,
                        MoneyCurrency.get(Currency.EUR).getMinPrice().getPrevious().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.EUR).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.EUR).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_CHF,
                        MoneyCurrency.get(Currency.CHF).getMinPrice().getPrevious().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.CHF).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.CHF).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_UAH,
                        MoneyCurrency.get(Currency.UAH).getMinPrice().getPrevious().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.UAH).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.UAH).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_TRY,
                        MoneyCurrency.get(Currency.TRY).getMinPrice().getPrevious().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.TRY).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.TRY).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_RUB,
                        MoneyCurrency.get(Currency.RUB).getMaxPrice().getNext().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_MORE
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.RUB).getMaxPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.RUB).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_USD,
                        MoneyCurrency.get(Currency.USD).getMaxPrice().getNext().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_MORE
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.USD).getMaxPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.USD).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_KZT,
                        MoneyCurrency.get(Currency.KZT).getMaxPrice().getNext().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_MORE
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.KZT).getMaxPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.KZT).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_EUR,
                        MoneyCurrency.get(Currency.EUR).getMaxPrice().getNext().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_MORE
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.EUR).getMaxPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.EUR).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_CHF,
                        MoneyCurrency.get(Currency.CHF).getMaxPrice().getNext().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_MORE
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.CHF).getMaxPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.CHF).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_UAH,
                        MoneyCurrency.get(Currency.UAH).getMaxPrice().getNext().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_MORE
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.UAH).getMaxPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.UAH).getJavaAPIAbbreviation(locale))},
                {AudienceTargetsLogins.LOGIN_RETARGETING_TRY,
                        MoneyCurrency.get(Currency.TRY).getMaxPrice().getNext().bidLong().longValue()
                        , new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_MORE
                        , capitalize(AudienceTargetAddItemMap.CONTEXT_BID)
                        , MoneyCurrency.get(Currency.TRY).getMaxPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED)
                        , MoneyCurrency.get(Currency.TRY).getJavaAPIAbbreviation(locale))},

        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        api.as(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL).get(0);
        userListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
    }

    @Test
    public void test() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(contextBid))
                , ExpectedResult.errors(notification));
    }
}
