package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetGetItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/TESTIRT-7489
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Проверка выставления ставок значений ставок по умолчанию при добавлении AudienceTargets")
@Issue("https://st.yandex-team.ru/DIRECT-45319")
@RunWith(Parameterized.class)
public class AddAudienceTargetsContextBidDefaultValuesTest {
    private Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public Currency currency;

    @Parameterized.Parameter(1)
    public String login;


    @Parameterized.Parameters(name = "Currency = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Currency.RUB, AudienceTargetsLogins.LOGIN_RETARGETING_RUB},
                {Currency.UAH, AudienceTargetsLogins.LOGIN_RETARGETING_UAH},
                {Currency.KZT, AudienceTargetsLogins.LOGIN_RETARGETING_KZT},
                {Currency.EUR, AudienceTargetsLogins.LOGIN_RETARGETING_EUR},
                {Currency.USD, AudienceTargetsLogins.LOGIN_RETARGETING_USD},
                {Currency.CHF, AudienceTargetsLogins.LOGIN_RETARGETING_CHF},
                {Currency.TRY, AudienceTargetsLogins.LOGIN_RETARGETING_TRY}
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createAdGroup() {
        api.as(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
    }

    @Test
    public void addAudienceDefaultContextBid() {
        long defaultBid = MoneyCurrency.get(currency).getLongMinPrice().longValue();
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        Long targetId = api.userSteps.audienceTargetsSteps().add(
                new AddRequestMap()
                        .withAudienceTargets(
                                new AudienceTargetAddItemMap()
                                        .withAdGroupId(pid)
                                        .withRetargetingListId(retargetingListsId)
                        )
        ).get(0);


        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.CONTEXT_BID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(targetId))
        );

        assertThat("ставки по умолчанию установились верно", targets,
                beanEquivalentV5(Arrays.asList(
                new AudienceTargetGetItemMap()
                        .withContextBid(defaultBid).getBean())));
    }
}
