package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by buhter on 03/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Невалидные значения ContextBid")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddAudienceTargetsContextBidValidationTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long pid;
    private static Long cid;
    private static Long userListsId;

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, LOGIN);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        userListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId, LOGIN);
    }

    @Parameterized.Parameters(name = "Description - {0}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {"Negative", -1L,
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS,
                                capitalize(AudienceTargetAddItemMap.CONTEXT_BID),
                                MoneyCurrency.get(Currency.RUB).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT),
                                MoneyCurrency.get(Currency.RUB).getJavaAPIAbbreviation(api.locale())))},
                {"Zero", 0L,
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS,
                                capitalize(AudienceTargetAddItemMap.CONTEXT_BID),
                                MoneyCurrency.get(Currency.RUB).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT),
                                MoneyCurrency.get(Currency.RUB).getJavaAPIAbbreviation(api.locale())))},
        };
        return Arrays.asList(data);
    }

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long contextBid;

    @Parameterized.Parameter(2)
    public ExpectedResult result;

    @Test
    public void test() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(contextBid))
                , result);
    }
}
