package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListTypeEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.PixelProvider;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetGetItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.directapi.model.AdfoxDealPlacement.getPlacementJsonsFromPageIds;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-83722")
public class AddAudienceTargetsCpmBannerTest {

    private static final String CLIENT_LOGIN = "at-add-subcl2";
    private static final String AGENCY_LOGIN = "at-add-agency-rep";
    private static final Long PUBLIC_GOAL_ID = 2499000002L;
    private static final Long PRIVATE_GOAL_ID = 2499000010L;
    public static final Long MIN_TEST_DEAL_ID = 2000000L;
    public static final Long MAX_TEST_DEAL_ID = 10000000L;
    public static final Long BIG_PLACEMENT_PAGE_ID = 63545390L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long userListsId;
    private static List<Long> goalIds;
    private static Long campaignId;
    private static Long creativeIdForCpmBanners;
    private Long pid;
    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT_LOGIN);

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_LOGIN);
        goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(CLIENT_LOGIN, RetargetingGoalType.GOAL);
        assumeThat("У клиента есть не меньше двух целей", goalIds, Matchers.hasSize(greaterThan(1)));
        userListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0), CLIENT_LOGIN);
        RetargetingConditionsRecord retargetingConditionsRecord =
                dbSteps.retargetingConditionSteps().getRetargeingConditionByRetCondId(userListsId);
        retargetingConditionsRecord
                .setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.interests);
        dbSteps.retargetingConditionSteps().updateRetargetingCondition(retargetingConditionsRecord);
        campaignId = api.userSteps.campaignSteps().addDefaultCampaign(CLIENT_LOGIN, CampaignType.TEXT);
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);

        creativeIdForCpmBanners =
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT_LOGIN).perfCreativesSteps()
                        .saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(CLIENT_LOGIN).getClientID()));
    }

    @Before
    public void initTest() {
        pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId, CLIENT_LOGIN);
    }


    private static void addForeignPlacements(Long cpmDealCampaignId) {
        api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(AGENCY_LOGIN)
                .placementsSteps()
                .addPlacement(BIG_PLACEMENT_PAGE_ID, 0);
        Long randomDealId = RandomUtils.nextLong(MIN_TEST_DEAL_ID, MAX_TEST_DEAL_ID);
        api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(AGENCY_LOGIN)
                .adfoxSteps()
                .addDeal(randomDealId, Long.parseLong(User.get(AGENCY_LOGIN).getClientID()),
                        getPlacementJsonsFromPageIds(singletonList(BIG_PLACEMENT_PAGE_ID)));
        api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(AGENCY_LOGIN)
                .dealsSteps()
                .addDeal(randomDealId, Long.parseLong(User.get(AGENCY_LOGIN).getClientID()));
        api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT_LOGIN)
                .campaignDealsSteps()
                .addCampaignDeal(randomDealId, cpmDealCampaignId, 0);
    }

    @Test
    public void tryAddToCpmVideoAdGroup() {
        Long pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId, CLIENT_LOGIN);
        dbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_video);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                CLIENT_LOGIN,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(
                                        MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue())),
                ExpectedResult.success());
    }

    @Test
    public void addToCpmDealsCampaign() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN);
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_DEALS);
        Long pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId, CLIENT_LOGIN);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                CLIENT_LOGIN,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(
                                        MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue())),
                ExpectedResult.success());
    }

    @Test
    public void tryAddToCpmDealsWithPixelsNegativeTest() {
        Long cpmAdGroupId = getCpmAdGroupWithDealsWithDcmPixelBanner();
        Long retargetingListId = getRetargetingListsWithCryptaGoal(PRIVATE_GOAL_ID);

        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                CLIENT_LOGIN,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(cpmAdGroupId)
                                .withRetargetingListId(retargetingListId)),
                ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetailsJava.NO_RIGHTS_TO_PIXEL,
                        PixelProvider.ADRIVER.testUrl()))
        );
    }

    @Test
    public void tryAddToCpmDealsWithPixelsPositiveTest() {
        Long cpmAdGroupId = getCpmAdGroupWithDealsWithDcmPixelBanner();
        Long retargetingListId = getRetargetingListsWithCryptaGoal(PUBLIC_GOAL_ID);

        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                CLIENT_LOGIN,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(cpmAdGroupId)
                                .withRetargetingListId(retargetingListId)),
                ExpectedResult.success()
        );

    }

    private Long getCpmAdGroupWithDealsWithDcmPixelBanner() {
        Long cpmDealCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN);
        api.userSteps.campaignFakeSteps().setType(cpmDealCampaignId, CampaignsType.CPM_DEALS);
        addForeignPlacements(cpmDealCampaignId);
        Long cpmAdGroupId = api.userSteps.adGroupsSteps()
                .addDefaultCpmBannerUserProfileAdGroup(cpmDealCampaignId, CLIENT_LOGIN);
        api.userSteps.adsSteps().addAd(new AdAddItemMap()
                        .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdAddMap()
                                .withHref(CpmBannerAdBuilderAdAddMap.DEFAULT_HREF)
                                .withCreative(creativeIdForCpmBanners)
                                .withTrackingPixels(singletonList(PixelProvider.ADRIVER.testUrl())))
                        .withAdGroupId(cpmAdGroupId),
                CLIENT_LOGIN
        );
        return cpmAdGroupId;
    }

    private Long getRetargetingListsWithCryptaGoal(Long goalId) {
        RetargetingListAddItemMap retargetingListAddItemMap = new RetargetingListAddItemMap()
                .withType(RetargetingListTypeEnum.AUDIENCE)
                .withName("Name" + RandomStringUtils.randomAlphabetic(3))
                .withDescription("Description" + RandomStringUtils.randomAlphabetic(3))
                .withRules(new RetargetingListRuleItemMap()
                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                .withMembershipLifeSpan(RandomUtils.nextInt(1, 90))
                                .withExternalId(goalId))
                        .withOperator(RetargetingListRuleOperatorEnum.ANY));
        Long retargetingListId = api.userSteps.retargetingListsSteps().add(CLIENT_LOGIN,
                new ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap()
                        .withRetargetingLists(retargetingListAddItemMap)
        ).get(0);
        return retargetingListId;
    }

    @Test
    public void testDefaultContextBid() {
        long defaultBid = MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue();
        Long audienctTargetId = api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                CLIENT_LOGIN,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)),
                ExpectedResult.success()).getAddResults().get(0).getId();
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                CLIENT_LOGIN,
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.CONTEXT_BID, AudienceTargetFieldEnum.STRATEGY_PRIORITY)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(audienctTargetId))
        );
        assertThat("ставки по умолчанию установились верно", targets,
                beanDifferV5(Collections.singletonList(
                        new AudienceTargetGetItemMap()
                                .withContextBid(defaultBid)
                                .withStrategyPriority(PriorityEnum.NORMAL).getBean())));
    }

    @Test
    public void testLessThanMinPrice() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                CLIENT_LOGIN,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(
                                        MoneyCurrency.get(Currency.RUB).getMinCpmPrice().getPrevious().bidLong()
                                                .longValue())),
                ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS,
                        capitalize(AudienceTargetAddItemMap.CONTEXT_BID),
                        MoneyCurrency.get(Currency.RUB).getMinCpmPrice()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        MoneyCurrency.get(Currency.RUB)
                                .getJavaAPIAbbreviation(DirectTestRunProperties.getInstance().getDirectAPILocale()))));
    }

    @Test
    public void testMoreThanMaxPrice() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                CLIENT_LOGIN,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(
                                        MoneyCurrency.get(Currency.RUB).getMaxCpmPrice().getNext().bidLong()
                                                .longValue())),
                ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_MORE,
                        capitalize(AudienceTargetAddItemMap.CONTEXT_BID),
                        MoneyCurrency.get(Currency.RUB).getMaxCpmPrice()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        MoneyCurrency.get(Currency.RUB)
                                .getJavaAPIAbbreviation(DirectTestRunProperties.getInstance().getDirectAPILocale()))));
    }

    @Test
    public void tryAddSecondAudienceTarget() {
        Long userListsIdElse = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(1), CLIENT_LOGIN);
        RetargetingConditionsRecord retargetingConditionsRecord =
                dbSteps.retargetingConditionSteps().getRetargeingConditionByRetCondId(userListsIdElse);
        retargetingConditionsRecord
                .setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.interests);
        dbSteps.retargetingConditionSteps().updateRetargetingCondition(retargetingConditionsRecord);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                CLIENT_LOGIN,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(
                                        MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue())),
                ExpectedResult.success());
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                CLIENT_LOGIN,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsIdElse)
                                .withContextBid(
                                        MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue())),
                ExpectedResult
                        .errors(new Notification(7000,
                                Api5ErrorDetailsJava.AUDIENCE_TARGETS_CPM_ADGRPOUP_LIMIT_EXCEEDED)));
    }

    @Test
    public void tryAddAudienceTargetToCpmBannerWithKeywordsAdGroup() {
        Long pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId, CLIENT_LOGIN);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                CLIENT_LOGIN,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(
                                        MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue())),
                ExpectedResult
                        .errors(new Notification(6001, Api5ErrorDetailsJava.ADGROUP_TYPE_NOT_SUPPORTED)));
    }
}
