package ru.yandex.autotests.direct.api.audiencetargets.add;

import com.yandex.direct.api.v5.retargetinglists.AddResponse;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Проверка области применения условия подбора")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AddAudienceTargetsDiffScopeTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET5;
    private static Long goalId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long pid;
    private static Long cid;

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);

    }

    @Test
    public void successAddRetargetingListsForTargetsAndAdjustment() {
        AddResponse addResponse = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRandomDescription()
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(goalId)
                                                                        .withRandomMembershipLifeSpan())
                                        )
                        ),
                ExpectedResult.success());
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(addResponse.getAddResults().get(0).getId())
                                .withContextBid(MoneyCurrency.get(User.get(LOGIN)
                                        .getCurrency()).getLongMinPrice().longValue()))
                , ExpectedResult.success());
    }

    @Test
    public void expectErrorAddRetargetingListsOnlyForAdjustment() {
        AddResponse addResponse = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRandomDescription()
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(goalId)
                                                                        .withRandomMembershipLifeSpan())
                                        )
                        ),
                ExpectedResult.success());
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(addResponse.getAddResults().get(0).getId())
                                .withContextBid(MoneyCurrency.get(User.get(LOGIN)
                                        .getCurrency()).getLongMinPrice().longValue()))
                , ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetailsJava.THIS_RETARGETING_LIST_CAN_BE_USED_ONLY_FOR_BID_MODIFIERS)));
    }
}
