package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.enums.DirectObjectType;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by buhter on 03/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Проверка добавления условия нацеливания с интересом в различные типы групп")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddAudienceTargetsInterestAdGroupTypesTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET2;
    private static Long interestId;
    private Long adGroupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        interestId = api.userSteps.dictionariesSteps().getInterestIdByIsTargetable(YesNoEnum.YES);
    }

    @Parameterized.Parameter(0)
    public DirectObjectType type;

    @Parameterized.Parameter(1)
    public ExpectedResult result;

    @Parameterized.Parameters(name = "Description - {0}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {DirectObjectType.TEXT,
                        ExpectedResult.errors(new Notification(6001, Api5ErrorDetails.ADGROUP_TYPE_NOT_SUPPORTED))},
                {DirectObjectType.DYNAMIC,
                        ExpectedResult.errors(new Notification(6001, Api5ErrorDetails.ADGROUP_TYPE_NOT_SUPPORTED))},
                {DirectObjectType.CPM_BANNER,
                        ExpectedResult.errors(new Notification(6001, Api5ErrorDetails.ADGROUP_TYPE_NOT_SUPPORTED))},
                {DirectObjectType.MOBILE_CONTENT, ExpectedResult.success()},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        Long campaignId = api.as(LOGIN).userSteps.campaignSteps().addDefaultCampaign(type.getCampaignType());
        if (type == DirectObjectType.CPM_BANNER){
            api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        }
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, type.getAdGroupType());
    }

    @Test
    public void addAudienceTargetsIntoDiffAdGroupType() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withInterestId(interestId)
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue())),
                result);
    }
}
