package ru.yandex.autotests.direct.api.audiencetargets.add;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 13.09.16.
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Валидация JSON-запроса при создании ретаргетинга")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AddAudienceTargetsJsonValidationTest {

    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET14;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void notArrayInAudienceTargets() {
        JSONObject request = new JSONObject();
        JSONObject audienceTarget = new JSONObject();
        audienceTarget.put(capitalize(AudienceTargetAddItemMap.RETARGETING_LIST_ID), 123);
        audienceTarget.put(capitalize(AudienceTargetAddItemMap.AD_GROUP_ID), 123);
        request.put(capitalize(AddRequestMap.AUDIENCE_TARGETS), audienceTarget);
        api.userSteps.audienceTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.AUDIENCE_TARGETS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(AddRequestMap.AUDIENCE_TARGETS)));
    }

    @Test
    public void invlidFieldInAudienceTargets() {
        JSONObject request = new JSONObject();
        JSONObject audienceTarget = new JSONObject();
        audienceTarget.put(capitalize(AudienceTargetAddItemMap.RETARGETING_LIST_ID), 123);
        audienceTarget.put(AudienceTargetAddItemMap.AD_GROUP_ID, 123);
        request.put(capitalize(AddRequestMap.AUDIENCE_TARGETS), new Object[]{audienceTarget});
        api.userSteps.audienceTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.AUDIENCE_TARGETS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AUDIENCE_TARGETS),
                        capitalize(AudienceTargetAddItemMap.AD_GROUP_ID)));
    }

    @Test
    public void stringInRetargetingListId() {
        JSONObject request = new JSONObject();
        JSONObject audienceTarget = new JSONObject();
        audienceTarget.put(capitalize(AudienceTargetAddItemMap.RETARGETING_LIST_ID), "String");
        audienceTarget.put(capitalize(AudienceTargetAddItemMap.AD_GROUP_ID), 123);
        request.put(capitalize(AddRequestMap.AUDIENCE_TARGETS), new Object[]{audienceTarget});
        api.userSteps.audienceTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.AUDIENCE_TARGETS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(AddRequestMap.AUDIENCE_TARGETS, AudienceTargetAddItemMap.RETARGETING_LIST_ID)));
    }
}
