package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Arrays;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 13.09.16.
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Проверка ограничения на количество объектов в запросе")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AddAudienceTargetsLimitTest {

    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET8;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long pid;
    private static Long retargetingListId;

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("у клиента должна быть цель", goalIds.size(), greaterThan(0));
        retargetingListId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0));
    }

    @Test
    public void moreThanMaxRetargetingListsInOneRequest() {
        AudienceTargetAddItemMap[] audienceTargetAddItemMaps =
                new AudienceTargetAddItemMap[AddRequestMap.MAX_AMOUNT_AUDIENCE_TARGETS_IN_ONE_REQUEST + 1];
        Arrays.fill(audienceTargetAddItemMaps,
                new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListId));
        api.userSteps.audienceTargetsSteps().expectErrorOnAdd(new AddRequestMap()
                        .withAudienceTargets(audienceTargetAddItemMaps),
                new Api5Error(9300,
                        Api5ErrorDetailsJava.AUDIENCE_TARGETS_ADD_LIMIT_EXCEEDED,
                        AddRequestMap.MAX_AMOUNT_AUDIENCE_TARGETS_IN_ONE_REQUEST));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }


    @Test
    public void maxRetargetingListsInOneRequest() {
        AudienceTargetAddItemMap[] audienceTargetAddItemMaps =
                new AudienceTargetAddItemMap[AddRequestMap.MAX_AMOUNT_AUDIENCE_TARGETS_IN_ONE_REQUEST];
        Arrays.fill(audienceTargetAddItemMaps,
                new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListId));
        ExpectedResult[] results =
                new ExpectedResult[AddRequestMap.MAX_AMOUNT_AUDIENCE_TARGETS_IN_ONE_REQUEST];
        Arrays.fill(results, ExpectedResult.errors(new Notification(9800,
                Api5ErrorDetailsJava.RETARGETING_LISTS_UNIQUE)));
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withAudienceTargets(audienceTargetAddItemMaps),
                results
        );
    }
}
