package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;


/**
 * Created by buhter on 03/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Description("Проверка валидации поля RetargetingListsId")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddAudienceTargetsRetargetingListIdTest {
    //DIRECT-58218
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET6;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long pid;
    private static Long cid;

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
    }

    @Parameterized.Parameters(name = "Description - {0}")
    public static Collection data() {
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long userListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        Object[][] data = new Object[][]{
                {"Correct RetargetingListId", userListsId
                        , ExpectedResult.success()},
                {"Null RetargetingListId and InterestId", null
                        , ExpectedResult.errors(new Notification(5008
                        , Api5ErrorDetails.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
                        String.format("%s, %s", capitalize(AudienceTargetAddItemMap.INTEREST_ID),
                                capitalize(AudienceTargetAddItemMap.RETARGETING_LIST_ID))))},
                {"Zero RetargetingListId", 0L
                        , ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                        capitalize(AudienceTargetAddItemMap.RETARGETING_LIST_ID)))},
                {"Negative RetargetingListId", -1L
                        , ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                        capitalize(AudienceTargetAddItemMap.RETARGETING_LIST_ID)))},
                {"Unexisting RetargetingListId", userListsId + 100000
                        , ExpectedResult.errors(new Notification(8800
                        , Api5ErrorDetails.NO_RETARGERTING_CONDITIONS_FOUND))},
        };
        return Arrays.asList(data);
    }

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long userListsId;

    @Parameterized.Parameter(2)
    public ExpectedResult result;

    @Test
    public void test() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
                , result);
    }
}
