package ru.yandex.autotests.direct.api.audiencetargets.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AudienceTargetsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-83722")
@RunWith(Parameterized.class)
public class AddToCpmBannerAdGroupRetargetingConditionsTypeTest {

    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long userListsId;
    private static Long campaignId;
    private Long pid;
    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

    @Parameterized.Parameter(0)
    public RetargetingConditionsRetargetingConditionsType type;

    @Parameterized.Parameter(1)
    public ExpectedResult result;

    @Parameterized.Parameters(name = "RetargetingConditionsType - {0}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {RetargetingConditionsRetargetingConditionsType.interests,
                        ExpectedResult.success()},
                {RetargetingConditionsRetargetingConditionsType.metrika_goals,
                        ExpectedResult.errors(new Notification(6001, Api5ErrorDetails.ADGROUP_TYPE_NOT_SUPPORTED))},
                {RetargetingConditionsRetargetingConditionsType.ab_segments,
                        ExpectedResult.errors(new Notification(6001, Api5ErrorDetails.ADGROUP_TYPE_NOT_SUPPORTED))},
                {RetargetingConditionsRetargetingConditionsType.dmp,
                        ExpectedResult.errors(new Notification(6001, Api5ErrorDetails.ADGROUP_TYPE_NOT_SUPPORTED))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        userListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId, LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
    }

    @Before
    public void initTest() {
        pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
    }

    @Test
    public void retargetingConditionsTypeTest() {
        RetargetingConditionsRecord retargetingConditionsRecord =
                dbSteps.retargetingConditionSteps().getRetargeingConditionByRetCondId(userListsId);
        retargetingConditionsRecord
                .setRetargetingConditionsType(type);
        dbSteps.retargetingConditionSteps().updateRetargetingCondition(retargetingConditionsRecord);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(userListsId)
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue())),
                result);
    }
}
