package ru.yandex.autotests.direct.api.audiencetargets.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by lightelfik on 7.07.16.
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Проверка работоспособности в случае ошибки в запросе")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AudienceTargetsWrongRequest {
    public static final int MIN_AUDIENCE_TARGETS_SIZE = 1;
    private static final String CLIENT = AudienceTargetsLogins.LOGIN_TARGET11;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void emptyRequest() {
        api.userSteps.audienceTargetsSteps().expectErrorOnAdd(new AddRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(AddRequestMap.AUDIENCE_TARGETS)));
    }

    @Test
    public void emptyArrayOfAudienceTargets() {
        api.userSteps.audienceTargetsSteps().expectErrorOnAdd(
                new AddRequestMap().withAudienceTargets(),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        capitalize(AddRequestMap.AUDIENCE_TARGETS), MIN_AUDIENCE_TARGETS_SIZE));
    }

    @Test
    public void nullInsteadOfAudienceTargetsItem() {
        api.userSteps.audienceTargetsSteps().expectErrorOnAdd(
                new AddRequestMap().withAudienceTargets(new AudienceTargetAddItemMap(null)),
                new Api5Error(8000, Api5ErrorDetailsJava.ARRAY_CONTAINS_NULL,
                        capitalize(AddRequestMap.AUDIENCE_TARGETS)));
    }

}
