package ru.yandex.autotests.direct.api.audiencetargets.delete;

import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRetargetingRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.DELETE)
@Description("Проверка верного удаления из базы методом Delete")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class DeleteAudienceTargetsAndCheckDBAndStatusesTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET11;
    private static int shard;
    private static Long target;
    private static Long pid;
    private static String lastChange;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        target = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);

        BidsRetargetingRecord bidsRetargeting = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsRetargetingSteps()
                .getBidsRetargeting(target);
        assumeThat("в базу записался объект", bidsRetargeting, notNullValue());

        lastChange = DateTime.now().minusMinutes(5).toString("yyyy-MM-dd hh:mm:ss");
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(pid);
        groupFakeInfo.setLastChange(lastChange);
        groupFakeInfo.setStatusBsSynced(Status.YES);
        groupFakeInfo.setStatusModerate(Status.YES);
        groupFakeInfo.setStatusPostModerate(Status.YES);
        api.userSteps.groupFakeSteps().updateGroupParams(groupFakeInfo);
        GroupFakeInfo actualGroupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(pid);
        assumeThat("группе установились ожидаемые параметры", actualGroupFakeInfo, beanDiffer(groupFakeInfo));

        api.userSteps.audienceTargetsSteps().shouldGetResultOnDelete(new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(target)), ExpectedResult.success());
    }

    @Test
    public void testDeleteBidsRetargetingSuccess() {
        BidsRetargetingRecord bidsRetargeting = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsRetargetingSteps()
                .getBidsRetargeting(target);
        assertThat("объект удалился из базы", bidsRetargeting, nullValue());
    }

    @Test
    public void checkAdGroupStatusBsSynced() {
        //DIRECT-58299
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(pid);
        assertThat("группа не синхронизирована с БК", groupFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    public void checkAdGroupLastChange() {
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(pid);
        assertThat("LastChange группы обновился", groupFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

}
