package ru.yandex.autotests.direct.api.audiencetargets.delete;

import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.DELETE)
@Description("Проверка работы метода с невалидными Ids")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class DeleteAudienceTargetsInvalidIdsTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET13;
    private static final String LOGIN_ANOTHER = AudienceTargetsLogins.LOGIN_TARGET14;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long retargetingListId;
    private static Long cid;
    private static Long pid;
    private static Long id;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN_ANOTHER);
        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        retargetingListId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
    }

    @Before
    public void before() {
        api.as(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        List<Long> ids = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", ids, iterableWithSize(1));
        id = ids.get(0);
    }

    @Test
    public void zeroId() {
        final long zeroId = 0L;
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(zeroId)),
                ExpectedResult.errors(
                        new Notification(5005, Api5ErrorDetailsJava.ID_MUST_BE_POSITIVE_INTEGER))
        );
    }

    @Test
    public void negativeId() {
        final long minusOne = -1L;
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(minusOne)),
                ExpectedResult.errors(
                        new Notification(5005, Api5ErrorDetailsJava.ID_MUST_BE_POSITIVE_INTEGER))
        );
    }

    @Test
    public void nonExistentId() {
        //DIRECT-58282
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(id + 10000)),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.AUDIENCE_TARGETS_NOT_FOUND))
        );
    }

    @Test
    public void deletedId() {
        //DIRECT-58282
        api.userSteps.audienceTargetsSteps().delete(id);
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(id)),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.AUDIENCE_TARGETS_NOT_FOUND))
        );
    }

    @Test
    public void idFromDeletedCampaign() {
        api.userSteps.campaignSteps().campaignsDelete(cid);
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(id)),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.AUDIENCE_TARGETS_NOT_FOUND))
        );
    }

    @Test
    public void idFromArchivedCampaign() {
        //DIRECT-58530
        api.userSteps.campaignSteps().campaignsSuspend(cid);
        api.userSteps.campaignSteps().campaignsArchive(cid);
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(id)),
                ExpectedResult.errors(
                        new Notification(8300,
                                Api5ErrorDetails.AUDIENCE_TARGETS_FORBIDDEN_TO_DELETE_IN_ARCHIVE_CAMPAIGN, cid))
        );
    }

    @Test
    public void anotherClientsId() {
        //DIRECT-58282
        api.as(LOGIN_ANOTHER).userSteps.audienceTargetsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(id)),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.AUDIENCE_TARGETS_NOT_FOUND))
        );
    }

    private static String selectionCriteriaId(int index) {
        return path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS, index).toString();
    }
}
