package ru.yandex.autotests.direct.api.audiencetargets.delete;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Phrases;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
@Features(AudienceTargetsFeatures.DELETE)
@Description("Удаление последнего активного условия отбора аудитории в группе")
public class DeleteLastActiveAudienceTargetInAdGroupTest {

    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET69;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameter(2)
    public BannerType adType;

    private BeanDifferMatcher expectedAdMatcher;
    private BeanDifferMatcher expectedAdGroupMatcher;
    private DirectJooqDbSteps directJooqDbSteps;
    private Long adGroupId;
    private Long adId;
    private Long targetId;

    @Parameterized.Parameters(name = "campaign type [{0}], group type [{1}], banner type [{2}]")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT},
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.IMAGE_AD},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.IMAGE_AD},
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        adId = api.userSteps.addDefaultAdWithType(adGroupId, adGroupType, adType);

        Long retargetingListId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(LOGIN);
        targetId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(adGroupId, retargetingListId);

        api.userSteps.bannersFakeSteps().makeBannersActiveAndFullyModerated(adId);
        directJooqDbSteps.adGroupsSteps().makePhraseModeratedAndBsSynced(adGroupId);
        api.userSteps.campaignFakeSteps().makeCampaignActive(campaignId);

        BannersRecord expectedAd = directJooqDbSteps.bannersSteps().getBanner(adId);
        expectedAdMatcher = beanDiffer(expectedAd.intoMap());

        PhrasesRecord expectedAdGroup = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId);
        expectedAdGroup.setStatusbssynced(PhrasesStatusbssynced.No);
        expectedAdGroupMatcher = beanDiffer(expectedAdGroup.intoMap()).useCompareStrategy(
                DefaultCompareStrategies.allFieldsExcept(
                        BeanFieldPath.newPath(Phrases.PHRASES.LASTCHANGE.getName())));
    }

    @Test
    @Description("Удаление последнего активного условия отбора аудитории в группе")
    public void deleteLastActiveAudienceTargetInAdGroupTest() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnDelete(new IdsCriteriaMap().withIds(targetId),
                ExpectedResult.success());

        BannersRecord ad = directJooqDbSteps.bannersSteps().getBanner(adId);
        assertThat("в БД баннер находится в ожидаемом состоянии", ad.intoMap(), expectedAdMatcher);

        PhrasesRecord adGroup = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId);
        assertThat("в БД группа находится в ожидаемом состоянии", adGroup.intoMap(), expectedAdGroupMatcher);
    }

}

