package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetGetItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка запросов для групп cpm_video")
@Issue("https://st.yandex-team.ru/DIRECT-96352")
public class GetAdGroupIdsCpmBannerTest {

    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET70;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long cpmBannerAdGroupId;
    private static Long cpmVideoAdGroupId;
    private static Long userListsId;
    private static Long cpmBannerTargetId;
    private static Long cpmVideoTargetId;
    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        userListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId, LOGIN);
        RetargetingConditionsRecord retargetingConditionsRecord =
                dbSteps.retargetingConditionSteps().getRetargeingConditionByRetCondId(userListsId);
        retargetingConditionsRecord
                .setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.interests);
        dbSteps.retargetingConditionSteps().updateRetargetingCondition(retargetingConditionsRecord);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);


        cpmVideoAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        cpmVideoTargetId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(cpmVideoAdGroupId, userListsId);
        dbSteps.adGroupsSteps().setType(cpmVideoAdGroupId, PhrasesAdgroupType.cpm_video);

        cpmBannerAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        cpmBannerTargetId =
                api.userSteps.audienceTargetsSteps().addWithRetargetingList(cpmBannerAdGroupId, userListsId);
    }

    @Test
    public void getByCampaignId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withCampaignIds(campaignId))
        );

        assertThat("объект получен", targets,
                containsInAnyOrder(new AudienceTargetGetItemMap().withId(cpmBannerTargetId).getBean(),
                        new AudienceTargetGetItemMap().withId(cpmVideoTargetId).getBean()));
    }

    @Test
    public void getByCpmBannerAdGroupId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withAdGroupIds(cpmBannerAdGroupId))
        );

        assertThat("объект получен", targets,
                beanDiffer(singletonList(new AudienceTargetGetItemMap().withId(cpmBannerTargetId).getBean())));
    }

    @Test
    public void getByCpmVideoAdGroupId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withAdGroupIds(cpmVideoAdGroupId))
        );

        assertThat("объект получен", targets,
                beanDiffer(singletonList(new AudienceTargetGetItemMap().withId(cpmVideoTargetId).getBean())));
    }

    @Test
    public void getByCpmBannerTargetId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(cpmBannerTargetId))
        );

        assertThat("объект получен", targets,
                beanDiffer(singletonList(new AudienceTargetGetItemMap().withId(cpmBannerTargetId).getBean())));
    }

    @Test
    public void getByCpmVideoTarget() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(cpmVideoTargetId))
        );

        assertThat("объект получен", targets,
                beanDiffer(singletonList(new AudienceTargetGetItemMap().withId(cpmVideoTargetId).getBean())));
    }

    @Test
    public void getByRetargetingListId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withRetargetingListsIds(userListsId))
        );

        assertThat("объект получен", targets,
                containsInAnyOrder(new AudienceTargetGetItemMap().withId(cpmBannerTargetId).getBean(),
                        new AudienceTargetGetItemMap().withId(cpmVideoTargetId).getBean()));
    }
}
