package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка запроса с невалидны AdGroupId")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetAdGroupIdsTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET20;
    private static final String LOGIN_ANOTHER = AudienceTargetsLogins.LOGIN_TARGET24;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long retargetingListId;
    private static Long cid;
    private static Long pid;
    private static Long id;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN_ANOTHER);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        retargetingListId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
    }

    @Before
    public void before() {
        api.as(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        List<Long> ids = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", ids, iterableWithSize(1));
        id = ids.get(0);
    }

    @Test
    public void getZeroId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.AD_GROUP_ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withAdGroupIds(0l))
        );

        assertThat("объект не получен", targets, hasSize(0));
    }

    @Test
    public void getNegativeId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.AD_GROUP_ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withAdGroupIds(-1l))
        );

        assertThat("объект не получен", targets, hasSize(0));
    }

    @Test
    public void getNonExistentId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.AD_GROUP_ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withAdGroupIds(pid + 10000))
        );

        assertThat("объект не получен", targets, hasSize(0));
    }

    @Test
    public void getByAdGroupWithDeletedId() {
        api.userSteps.audienceTargetsSteps().delete(id);
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.AD_GROUP_ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withAdGroupIds(pid))
        );

        assertThat("объект не получен", targets, hasSize(0));
    }

    @Test
    public void getByAdGroupIdFromDeletedCampaign() {
        api.userSteps.campaignSteps().campaignsDelete(cid);
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.AD_GROUP_ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withAdGroupIds(pid))
        );

        assertThat("объект не получен", targets, hasSize(0));
    }

    @Test
    public void getByAdGroupIdFromArchivedCampaign() {
        api.userSteps.campaignSteps().campaignsSuspend(cid);
        api.userSteps.campaignSteps().campaignsArchive(cid);
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.AD_GROUP_ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withAdGroupIds(pid))
        );

        assertThat("объект получен", targets, hasSize(1));
    }

    @Test
    public void getByAnotherClientsAdGroupId() {
        api.as(LOGIN_ANOTHER);
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.AD_GROUP_ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withAdGroupIds(pid))
        );

        assertThat("объект не получен", targets, hasSize(0));
    }
}
