package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetGetItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка получения State ")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetFieldNamesTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET22;
    private static List<Long> audienceTargetIds;
    private static Long retargetingListsId;
    private static Long cid;
    private static Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        audienceTargetIds = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListsId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", audienceTargetIds, iterableWithSize(1));
    }

    @Test
    public void getFullFieldNames() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFullFieldNames()
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(audienceTargetIds.get(0)))
        );

        assertThat("получен ожидаемый объект", targets,
                beanDifferV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withId(audienceTargetIds.get(0))
                                .withAdGroupId(pid)
                                .withCampaignId(cid)
                                .withInterestId(null)
                                .withRetargetingListId(retargetingListsId)
                                .withStrategyPriority(PriorityEnum.NORMAL)
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue())
                                .withState(StateEnum.ON)
                                .getBean())));
    }

    @Test
    public void getId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(audienceTargetIds.get(0)))
        );

        assertThat("получен ожидаемый объект", targets,
                beanDifferV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withId(audienceTargetIds.get(0))
                                .getBean())));
    }

    @Test
    public void getAdGroupId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.AD_GROUP_ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(audienceTargetIds.get(0)))
        );

        assertThat("получен ожидаемый объект", targets,
                beanDifferV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withAdGroupId(pid)
                                .getBean())));
    }

    @Test
    public void getCampaignId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.CAMPAIGN_ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(audienceTargetIds.get(0)))
        );

        assertThat("получен ожидаемый объект", targets,
                beanDifferV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withCampaignId(cid)
                                .getBean())));
    }

    @Test
    public void getByRetargetingListsId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.RETARGETING_LIST_ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(audienceTargetIds.get(0)))
        );

        assertThat("получен ожидаемый объект", targets,
                beanDifferV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withRetargetingListId(retargetingListsId)
                                .getBean())));
    }

    @Test
    public void getByStrategyPriority() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.STRATEGY_PRIORITY)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(audienceTargetIds.get(0)))
        );

        assertThat("получен ожидаемый объект", targets,
                beanDifferV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withStrategyPriority(PriorityEnum.NORMAL)
                                .getBean())));
    }

    @Test
    public void getByContextBid() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.CONTEXT_BID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(audienceTargetIds.get(0)))
        );

        assertThat("получен ожидаемый объект", targets,
                beanDifferV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue())
                                .getBean())));
    }

    @Test
    public void getByState() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.STATE)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(audienceTargetIds.get(0)))
        );

        assertThat("получен ожидаемый объект", targets,
                beanDifferV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withState(StateEnum.ON)
                                .getBean())));
    }

}
