package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetStateEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка невалидного типа полей метода Get")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetInvalidTypesOfFieldsTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET27;
    private static List<Long> audienceTargetIds;
    public static Integer intValue = 123;
    public static String stringValue = "stringValue";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long goalId = api.userSteps.retargetingSteps()
                .getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        audienceTargetIds = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListsId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", audienceTargetIds, iterableWithSize(1));
    }

    @Test
    public void invalidTypeOfSelectionCriteria() {
        JSONObject request = new JSONObject();
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), intValue);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    public void invalidTypeOfFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{audienceTargetIds.get(0)});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), intValue);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.FIELD_NAMES))
        );
    }

    @Test
    public void invalidTypeInPage() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{audienceTargetIds.get(0)});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        request.put(capitalize(GetRequestMap.PAGE), intValue);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                        path(GetRequestMap.PAGE))
        );
    }

    @Test
    public void invalidTypeOfLimit() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{audienceTargetIds.get(0)});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), stringValue);
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.PAGE, LimitOffsetMap.LIMIT))
        );
    }

    @Test
    public void invalidTypeOfOffset() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{audienceTargetIds.get(0)});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.OFFSET), stringValue);
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.PAGE, LimitOffsetMap.OFFSET))
        );
    }

    @Test
    public void invalidTypeInIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new String[]{stringValue});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.IDS)
                )
        );
    }

    @Test
    public void invalidTypeInAdGroupIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.AD_GROUP_IDS), new String[]{stringValue});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.AD_GROUP_IDS))
        );
    }

    @Test
    public void invalidTypeInCampaignIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.CAMPAIGN_IDS), new String[]{stringValue});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.CAMPAIGN_IDS))
        );
    }

    @Test
    public void invalidTypeInStates() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{audienceTargetIds.get(0)});
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.STATES), new Integer[]{intValue});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.STATES),
                        Api5Error.enumAsParam(AudienceTargetStateEnum.class))
        );
    }
}
