package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetStateEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка невалидной стуктуры полей метода Get")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetJsonValidationTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET28;
    private static final String PARAMS = "params";
    private static Long id;
    private static Long pid;
    private static Long cid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        List<Long> audienceTargetIds = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListsId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", audienceTargetIds, iterableWithSize(1));
        id = audienceTargetIds.get(0);
    }

    @Test
    public void invalidFieldInParams() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(GetRequestMap.SELECTION_CRITERIA, selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        GetRequestMap.SELECTION_CRITERIA)
        );
    }

    @Test
    public void invalidFieldInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(AudienceTargetSelectionCriteriaMap.IDS, new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        path(GetRequestMap.SELECTION_CRITERIA) + "." + AudienceTargetSelectionCriteriaMap.IDS)
        );
    }

    @Test
    public void invalidFieldInPage() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        page.put(LimitOffsetMap.LIMIT, 1l);
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        path(GetRequestMap.PAGE) + "." + LimitOffsetMap.LIMIT)
        );
    }

    @Test
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_REQUEST_FORMAT)
        );
    }

    @Test
    public void arrayInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    public void arrayInPage() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), 1l);
        request.put(capitalize(GetRequestMap.PAGE), new Object[]{page});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(GetRequestMap.PAGE))
        );
    }

    @Test
    public void arrayInLimit() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), new Object[]{1l});
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(GetRequestMap.PAGE, LimitOffsetMap.LIMIT))
        );
    }

    @Test
    public void arrayInOffset() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), 1l);
        page.put(capitalize(LimitOffsetMap.OFFSET), new Object[]{1l});
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(GetRequestMap.PAGE, LimitOffsetMap.OFFSET))
        );
    }

    @Test
    public void notArrayInFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), AudienceTargetFieldEnum.ID);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.FIELD_NAMES))
        );
    }

    @Test
    public void invalidValueInFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{AudienceTargetFieldEnum.ID.value(), StateEnum.SUSPENDED.value()});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.FIELD_NAMES), Api5Error.enumAsParam(AudienceTargetFieldEnum.class))
        );
    }

    @Test
    public void notArrayInIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), id);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.IDS))
        );
    }


    @Test
    public void notArrayInAdGroupIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.AD_GROUP_IDS), pid);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.AD_GROUP_IDS))
        );
    }


    @Test
    public void notArrayInCampaignIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.CAMPAIGN_IDS), cid);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.CAMPAIGN_IDS))
        );
    }


    @Test
    public void notArrayInStates() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.STATES), StateEnum.SUSPENDED);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.STATES))
        );
    }

    @Test
    public void invalidValueInStates() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(AudienceTargetSelectionCriteriaMap.STATES), new String[]{"UNKNOWN"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AudienceTargetFieldEnum.ID});
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.STATES),
                        Api5Error.enumAsParam(AudienceTargetStateEnum.class))
        );
    }
}
