package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка запроса с кол-вом Id превышающим максимальный")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetLimitNegativeTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET29;
    private static Long interestId;
    private static List<Long> audienceTargetIdsWithRetargetingLists;
    private static List<Long> audienceTargetIdsWithInterests;
    private static Long retargetingListsId;
    private static Long cid;
    private static Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        interestId = api.userSteps.dictionariesSteps().getInterestIdByIsTargetable(YesNoEnum.YES);

        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        audienceTargetIdsWithRetargetingLists = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListsId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", audienceTargetIdsWithRetargetingLists, iterableWithSize(1));
        audienceTargetIdsWithInterests = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withInterestId(interestId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", audienceTargetIdsWithInterests, iterableWithSize(1));
    }

    @Test
    public void moreThanMaxIdsInSelectionCriteria() {
        Long[] ids = new Long[AudienceTargetSelectionCriteriaMap.MAX_AMOUNT_OF_IDS + 1];
        Arrays.fill(ids, audienceTargetIdsWithRetargetingLists.get(0));
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(ids)),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.IDS))
        );
    }

    @Test
    public void moreThanMaxAdGroupIdsInSelectionCriteria() {
        Long[] ids = new Long[AudienceTargetSelectionCriteriaMap.MAX_AMOUNT_OF_AD_GROUP_IDS + 1];
        Arrays.fill(ids, pid);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withAdGroupIds(ids)),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.AD_GROUP_IDS)));
    }

    @Test
    public void moreThanMaxCampaignIdsInSelectionCriteria() {
        Long[] ids = new Long[AudienceTargetSelectionCriteriaMap.MAX_AMOUNT_OF_CAMPAIGN_IDS + 1];
        Arrays.fill(ids, cid);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withCampaignIds(ids)),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.CAMPAIGN_IDS)));
    }

    @Test
    public void moreThanMaxRetargetingListsInSelectionCriteria() {
        Long[] ids = new Long[AudienceTargetSelectionCriteriaMap.MAX_AMOUNT_OF_RETARGETING_LISTS_IDS + 1];
        Arrays.fill(ids, retargetingListsId);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withRetargetingListsIds(ids)),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                        path(GetRequestMap.SELECTION_CRITERIA,
                                AudienceTargetSelectionCriteriaMap.RETARGETING_LISTS_IDS)));
    }

    @Test
    public void moreThanMaxInterestsInSelectionCriteria() {
        Long[] ids = new Long[AudienceTargetSelectionCriteriaMap.MAX_AMOUNT_OF_INTEREST_IDS + 1];
        Arrays.fill(ids, interestId);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withInterestIds(ids)),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                        path(GetRequestMap.SELECTION_CRITERIA, AudienceTargetSelectionCriteriaMap.INTEREST_IDS)));
    }
}

