package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetGetItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка запроса с макисмальным колвом Id")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetLimitPositiveTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET30;
    private static List<Long> audienceTargetIdsWithRetargetingLists;
    private static List<Long> audienceTargetIdsWithInterests;
    private static Long retargetingListsId;
    private static Long cid;
    private static Long pid1;
    private static Long pid2;
    private static Long interestId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.deleteAllRetargetingListsByLogin(LOGIN);
        api.userSteps.deleteAllActiveCampaignsByLogin(LOGIN);

        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        interestId = api.userSteps.dictionariesSteps().getInterestIdByIsTargetable(YesNoEnum.YES);

        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        pid1 = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        audienceTargetIdsWithRetargetingLists = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid1)
                        .withRetargetingListId(retargetingListsId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", audienceTargetIdsWithRetargetingLists, iterableWithSize(1));
        pid2 = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        audienceTargetIdsWithInterests = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid2)
                        .withInterestId(interestId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", audienceTargetIdsWithInterests, iterableWithSize(1));
    }

    @Test
    public void maxIdsInSelectionCriteria() {
        Long[] ids = new Long[AudienceTargetSelectionCriteriaMap.MAX_AMOUNT_OF_IDS];
        Arrays.fill(ids, audienceTargetIdsWithRetargetingLists.get(0));
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(ids))
        );

        assertThat("получен ожидаемый объект", targets,
                beanEquivalentV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withId(audienceTargetIdsWithRetargetingLists.get(0)).getBean())));
    }

    @Test
    public void maxAdGroupIdsInSelectionCriteria() {
        Long[] ids = new Long[AudienceTargetSelectionCriteriaMap.MAX_AMOUNT_OF_AD_GROUP_IDS];
        Arrays.fill(ids, pid1);
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withAdGroupIds(ids))
        );

        assertThat("получен ожидаемый объект", targets,
                beanEquivalentV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withId(audienceTargetIdsWithRetargetingLists.get(0)).getBean())));
    }

    @Test
    public void maxCampaignIdsInSelectionCriteria() {
        Long[] ids = new Long[AudienceTargetSelectionCriteriaMap.MAX_AMOUNT_OF_CAMPAIGN_IDS];
        Arrays.fill(ids, cid);
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withAdGroupIds(pid1)
                                        .withCampaignIds(ids))
        );

        assertThat("получен ожидаемый объект", targets,
                beanEquivalentV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withId(audienceTargetIdsWithRetargetingLists.get(0)).getBean())));
    }

    @Test
    public void maxRetargetingListsInSelectionCriteria() {
        Long[] ids = new Long[AudienceTargetSelectionCriteriaMap.MAX_AMOUNT_OF_RETARGETING_LISTS_IDS];
        Arrays.fill(ids, retargetingListsId);
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withRetargetingListsIds(ids))
        );

        assertThat("получен ожидаемый объект", targets,
                beanEquivalentV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withId(audienceTargetIdsWithRetargetingLists.get(0)).getBean())));
    }

    @Test
    public void maxInterestsInSelectionCriteria() {
        Long[] ids = new Long[AudienceTargetSelectionCriteriaMap.MAX_AMOUNT_OF_INTEREST_IDS];
        Arrays.fill(ids, interestId);
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withInterestIds(ids))
        );

        assertThat("получен ожидаемый объект", targets,
                beanEquivalentV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withId(audienceTargetIdsWithInterests.get(0)).getBean())));
    }
}
