package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка обязательных полей")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetMandatoryFieldsTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET31;
    private static List<Long> audienceTargetIds;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        audienceTargetIds = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListsId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", audienceTargetIds, iterableWithSize(1));
    }

    @Test
    public void getEmptyRequest() {
        // В Java-сервисе возвращается ошибка для поля, идущего первым по алфавиту - FieldsNames
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap().withFullFieldNames(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void getWithoutSelectionCriteria() {
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    public void getWithoutIds() {
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap())
                        .withFieldNames(AudienceTargetFieldEnum.ID),
                new Api5Error(4001, Api5ErrorDetailsJava.MISSED_REQUIRED_PARAMETER_IN_SELECTION)
        );
    }

    @Test
    public void getWithStateAndWithoutIds() {
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap().withStates(StateEnum.ON))
                        .withFieldNames(AudienceTargetFieldEnum.ID),
                new Api5Error(4001, Api5ErrorDetailsJava.MISSED_REQUIRED_PARAMETER_IN_SELECTION)
        );
    }

    @Test
    public void getWithoutFieldNames() {
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(audienceTargetIds.get(0))),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(GetRequestMap.FIELD_NAMES))
        );
    }

}

