package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.audiencetargets.GetResponse;
import com.yandex.direct.api.v5.retargetinglists.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetGetItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListGetItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extractProperty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка логики полей Limit и Offset в Page")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetPageTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET33;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.SOAP);
    private static List<Long> audienceTargetIds;

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("у клиента должно быть > 1 цели", goalIds.size(), greaterThan(1));
        AddResponse retargetingLists = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(6)
                                                .withExternalId(goalIds.get(0))),

                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(87)
                                                .withExternalId(goalIds.get(0))),
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(87)
                                                .withExternalId(goalIds.get(1))),

                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(5)
                                                .withExternalId(goalIds.get(1)))),
                ExpectedResult.success(), ExpectedResult.success(), ExpectedResult.success(), ExpectedResult.success());

        List<Long> ids = extractProperty(retargetingLists.getAddResults(), RetargetingListGetItemMap.ID);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        audienceTargetIds = api.userSteps.audienceTargetsSteps().add(
                new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(ids.get(0))
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()),
                new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(ids.get(1))
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()),
                new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(ids.get(2))
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()),
                new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(ids.get(3))
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue())
        );
    }


    @Test
    public void getHead() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                                        .withOffset(0L)));
        List<Long> gotids = extractProperty(targets, AudienceTargetGetItemMap.ID);
        assertThat("вернулся правильный набор audienceTargets", gotids, equalTo(Arrays.asList(audienceTargetIds.get(0), audienceTargetIds.get(1))));
    }

    @Test
    public void getBody() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                                        .withOffset(1L)));
        List<Long> gotids = extractProperty(targets, AudienceTargetGetItemMap.ID);
        assertThat("вернулся правильный набор audienceTargets", gotids, equalTo(Arrays.asList(audienceTargetIds.get(1), audienceTargetIds.get(2))));
    }

    @Test
    public void getTail() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                                        .withOffset(2L)));
        List<Long> gotids = extractProperty(targets, AudienceTargetGetItemMap.ID);
        assertThat("вернулся правильный набор audienceTargets", gotids,
                equalTo(Arrays.asList(audienceTargetIds.get(2), audienceTargetIds.get(3))));
    }

    @Test
    public void getPartOfTail() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                                        .withOffset(3L)));
        List<Long> gotids = extractProperty(targets, AudienceTargetGetItemMap.ID);
        assertThat("вернулся правильный набор audienceTargets", gotids, equalTo(Arrays.asList(audienceTargetIds.get(3))));
    }

    @Test
    public void getOverTail() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                                        .withOffset(4L)));
        assertThat("вернулся правильный набор audienceTargets", targets, hasSize(0));
    }

    @Test
    public void onlyLimit() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)));
        List<Long> gotids = extractProperty(targets, AudienceTargetGetItemMap.ID);
        assertThat("вернулся правильный набор audienceTargets", gotids, equalTo(Arrays.asList(audienceTargetIds.get(0), audienceTargetIds.get(1))));
    }

    @Test
    public void onlyOffset() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(2L)));
        List<Long> gotids = extractProperty(targets, AudienceTargetGetItemMap.ID);
        assertThat("вернулся правильный набор audienceTargets", gotids, equalTo(Arrays.asList(audienceTargetIds.get(2), audienceTargetIds.get(3))));
    }

    @Test
    public void zeroLimit() {
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(0L)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0));
    }

    @Test
    public void negativeLimit() {
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(-1L)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0));
    }

    @Test
    public void maxLimit() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(LimitOffsetMap.LIMIT_MAX_LENGTH)));
        List<Long> gotids = extractProperty(targets, AudienceTargetGetItemMap.ID);
        assertThat("вернулся правильный набор audienceTargets", gotids,
                equalTo(Arrays.asList(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3))));
    }

    @Test
    public void overMaxLimit() {
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(LimitOffsetMap.LIMIT_MAX_LENGTH + 1)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_CANNOT_BE_MORE, LimitOffsetMap.LIMIT_MAX_LENGTH));
    }

    @Test
    public void negativeOffset() {
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(-1L)),
                new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0));
    }

    @Test
    public void checkLimitedByIfLimitDidntWork() {
        GetResponse getResponse = api.userSteps.audienceTargetsSteps().audienceTargetsGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(4L)));
        assertThat("значение LimitedBy верно", getResponse.getLimitedBy(), nullValue());
    }

    @Test
    public void checkLimitedByIfLimitWorked() {
        GetResponse getResponse = api.userSteps.audienceTargetsSteps().audienceTargetsGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), audienceTargetIds.get(2), audienceTargetIds.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(1L)
                                        .withLimit(2L)));
        assertThat("значение LimitedBy верно", getResponse.getLimitedBy(), equalTo(3L));
    }

    @Test
    public void useLimitAndNotExistAudienceTarger() {
        long nonExistId = audienceTargetIds.get(0) + 1000;
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1), nonExistId))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)));
        List<Long> gotids = extractProperty(targets, AudienceTargetFieldEnum.ID.value());
        assertThat("вернулся правильный набор audienceTargets", gotids, equalTo(Arrays.asList(audienceTargetIds.get(0), audienceTargetIds.get(1))));
    }

}

