package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка вызова метода get под ролями")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class GetRoleTest {
    private static final String CLIENT = "at-client-webpages";
    private static final String CLIENT_REP = "at-rep-client-webpages";
    private static final String AGENCY = "at-agency-webpages";
    private static final String AGENCY_REP =  "at-rep-agency-webpages";
    private static final String SUBCLIENT = "at-subclient-webpages";
    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String SERV_CLIENT = "at-serv-webpages";
    private static final String SUPER = Logins.SUPER_LOGIN;
    private static final String SUPER_READER = Logins.SUPER_READER;
    private static final String PLACER = Logins.PLACER;
    private static final String SUPPORT = Logins.SUPPORT;
    private static final String MEDIA = Logins.MEDIA;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String loginToAddRetargetingList;

    @Parameterized.Parameter(2)
    public String apiUserLogin;

    @Parameterized.Parameter(3)
    public String login;

    private List<Long> audienceTargetIds;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList((Object[][])new Object[][]{
                {"Получение условий от имени менеджера", MANAGER, MANAGER, SERV_CLIENT},

                {"Получение условий от имени вешальщика", SUPER, PLACER, CLIENT},

                {"Получение условий от имени саппорта", SUPER, SUPPORT, CLIENT},

                {"Получение условий от имени супера", SUPER, SUPER, CLIENT},

                {"Получение условий от имени медиапланера", SUPER, MEDIA, CLIENT},

                {"Получение условий от имени суперридера", SUPER, SUPER_READER, CLIENT},

                {"Получение условий от имени клиента для самого себя", SUPER, CLIENT, CLIENT},

                {"Получение условий от имени представителя клиента для клиента", SUPER, CLIENT_REP, CLIENT},

                {"Получение условий от имени агенства для субклиента", AGENCY, AGENCY, SUBCLIENT},

                {"Получение условий от имени представителя агенства для субклиента", AGENCY_REP, AGENCY_REP, SUBCLIENT},

                {"Получение условий от имени субклиента для самого себя", AGENCY, SUBCLIENT, SUBCLIENT}
        });
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL).get(0);
        api.as(loginToAddRetargetingList);
        Long retargetingListId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId, login);
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, login);
        audienceTargetIds = api.userSteps.audienceTargetsSteps().add(login, new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListId)
                        .withContextBid(MoneyCurrency.get(User.get(login).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", audienceTargetIds, iterableWithSize(1));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
    }

    @Test
    public void getUsingLogin() {
        api.as(apiUserLogin);
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                login,
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(audienceTargetIds.get(0)))
        );

        assertThat("получен ожидаемый объект", targets, hasSize(1));
    }
}
