package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetGetItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка SOAP запроса")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetSoapTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET33;
    private static Long retargetingListsId;
    private static List<Long> audienceTargetIds;
    private static Long pid;
    private static Long cid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        audienceTargetIds = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListsId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", audienceTargetIds, iterableWithSize(1));
    }

    @Test
    public void getSoapRequest() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFullFieldNames()
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(audienceTargetIds.get(0)))
        );

        assertThat("получен ожидаемый объект", targets,
                beanDifferV5(Arrays.asList(
                        new AudienceTargetGetItemMap()
                                .withId(audienceTargetIds.get(0))
                                .withAdGroupId(pid)
                                .withCampaignId(cid)
                                .withInterestId(null)
                                .withRetargetingListId(retargetingListsId)
                                .withStrategyPriority(PriorityEnum.NORMAL)
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue())
                                .withState(StateEnum.ON)
                                .getBean())));
    }
}
