package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка списания баллов API")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetUnitTest {
    private static final int GET_COST = 1;
    private static final int ITEM_COST_ON_GET = 1;
    private static final int GENERAL_FAULT_COST = 50;
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET68;
    private static Long cid;
    private static Long pid;
    private static List<Long> audienceTargetIds;
    private static Long id1;
    private static Long id2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        List<Long> goalIds =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("у клиента должно быть > 1 цели", goalIds.size(), greaterThan(1));
        id1 = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0));
        id2 = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(1));
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        audienceTargetIds = api.userSteps.audienceTargetsSteps().add(
                new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(id1)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()),
                new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(id2)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue())
        );
    }

    @Before
    public void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void getSuccess() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0))));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("стоимость получения одного объекта", unitsBefore - unitsAfter,
                equalTo(GET_COST + ITEM_COST_ON_GET));
    }

    @Test
    public void getSomeAudienceTargets() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0), audienceTargetIds.get(1))));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("стоимость получения двух объектов", unitsBefore - unitsAfter,
                equalTo(GET_COST + ITEM_COST_ON_GET * 2));
    }

    @Test
    public void getAudienceTargetsByPid() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withAdGroupIds(pid)));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("стоимость получения двух объектов", unitsBefore - unitsAfter,
                equalTo(GET_COST + ITEM_COST_ON_GET * 2));
    }

    @Test
    public void getAudienceTargetsByCid() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withCampaignIds(cid)));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("стоимость получения двух объектов", unitsBefore - unitsAfter,
                equalTo(GET_COST + ITEM_COST_ON_GET * 2));
    }

    @Test
    public void getAudienceTargetsByRetargetingLists() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withRetargetingListsIds(id1, id2)));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("стоимость получения двух объектов", unitsBefore - unitsAfter,
                equalTo(GET_COST + ITEM_COST_ON_GET * 2));
    }

    @Test
    public void getNonExistingAudienceTargets() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(1L)));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("списалось верное кол-во баллов", unitsBefore - unitsAfter, equalTo(GET_COST));
    }

    @Test
    public void generalErrorOnGetAudienceTargets() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(GetRequestMap.FIELD_NAMES))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("списалось верное кол-во баллов", unitsBefore - unitsAfter, equalTo(GENERAL_FAULT_COST));
    }

    @Test
    public void notEnoughUnitsOnGetAudienceTargets() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(LOGIN, unitsBefore);
        unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assumeThat("доступные баллы пользователя", unitsBefore, equalTo(0));

        api.userSteps.audienceTargetsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetIds.get(0))),
                new Api5Error(152, Api5ErrorDetails.NOT_ENOUGH_UNITS_FOR_OPERATION));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("доступные баллы пользователя после ошибки", unitsAfter, equalTo(0));
    }

}

