package ru.yandex.autotests.direct.api.audiencetargets.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetGetItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 14.09.16.
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + AdGroupIds)")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class IdsWithAdGroupIdsFilterTest {

    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET67;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    static Long campaignId1;
    static Long campaignId2;
    static Long adGroupId1;
    static Long adGroupId2;
    static Long firstIdFromAdGroup1;
    static Long secondIdFromAdGroup1;
    static Long idFromAdGroup2;
    static Long retargetingListId1;
    static Long retargetingListId2;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assertThat("у клиента более одной цели", goalIds.size(), greaterThan(1));
        retargetingListId1 = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0));
        retargetingListId2 = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(1));

        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1);
        firstIdFromAdGroup1 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(adGroupId1, retargetingListId1);
        secondIdFromAdGroup1 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(adGroupId1, retargetingListId2);
        campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId2);
        idFromAdGroup2 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(adGroupId2, retargetingListId1);

        api.userSteps.audienceTargetsSteps().suspend(secondIdFromAdGroup1);
    }

    @Test
    public void getAdGroupWithTwoIdsAndId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1)
                                        .withAdGroupIds(adGroupId1))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getAdGroupWithOtherIdAndId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1)
                                        .withAdGroupIds(adGroupId2))
        );
        assertThat("не вернулось ни одного условия нацеливания", targets, hasSize(0));
    }

    @Test
    public void getAdGroupAndTwoIds() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1, idFromAdGroup2)
                                        .withAdGroupIds(adGroupId1))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getTwoAdGroupsAndId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1)
                                        .withAdGroupIds(adGroupId1, adGroupId2))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getCampaignWithTwoIdsAndId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1)
                                        .withCampaignIds(campaignId1))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getCampaignWithOtherIdAndId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1)
                                        .withCampaignIds(campaignId2))
        );
        assertThat("не вернулось ни одного условия нацеливания", targets, hasSize(0));
    }

    @Test
    public void getCampaignAndTwoIds() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1, idFromAdGroup2)
                                        .withCampaignIds(campaignId1))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getTwoACampaignsAndId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1)
                                        .withCampaignIds(campaignId1, campaignId2))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getRetargetingListWithTwoIdsAndId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1)
                                        .withRetargetingListsIds(retargetingListId1))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getRetargetingListWithOtherIdAndId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1)
                                        .withRetargetingListsIds(retargetingListId2))
        );
        assertThat("не вернулось ни одного условия нацеливания", targets, hasSize(0));
    }

    @Test
    public void getRetargetingListAndTwoIds() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1, secondIdFromAdGroup1)
                                        .withRetargetingListsIds(retargetingListId1))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getTwoRetargetingListsAndId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1)
                                        .withRetargetingListsIds(retargetingListId1, retargetingListId2))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getAdGroupIdWithRetargetingListId() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withAdGroupIds(adGroupId1)
                                        .withRetargetingListsIds(retargetingListId1))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getTwoIdsAndStateOn() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1, secondIdFromAdGroup1)
                                        .withStates(StateEnum.ON))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(firstIdFromAdGroup1).getBean())
        ));
    }

    @Test
    public void getTwoIdsAndStateSuspended() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(firstIdFromAdGroup1, secondIdFromAdGroup1)
                                        .withStates(StateEnum.SUSPENDED))
        );
        assertThat("вернулся правильный ответ", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withId(secondIdFromAdGroup1).getBean())
        ));
    }
}
