package ru.yandex.autotests.direct.api.audiencetargets.production;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Smoke-тесты на проверку некоторых методов на production окружении
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-66636")
@Features(ApiFeatures.PRODUCTION)
@Description("Production smoke test: AudienceTargets. Создание/получение.")
public class GetAudienceTargetsProdTest {

    private static String client = AudienceTargetsLogins.LOGIN_TARGET58;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long audienceTargetId;

    @Before
    public void before() {
        Long goalId = api.userSteps.retargetingSteps()
                .getRetargetingGoalIDsByType(client, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        List<Long> audienceTargetIds = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListsId)
                        .withContextBid(MoneyCurrency.get(
                                User.get(client).getCurrency())
                                .getLongMinPrice()
                                .longValue())));
        assumeThat("Создан один объект", audienceTargetIds, iterableWithSize(1));

        audienceTargetId = audienceTargetIds.get(0);
    }

    @Test
    public void getAudienceTargetsTest() {
        GetResponse response = api.userSteps.audienceTargetsSteps()
                .audienceTargetsGet(client, new GetRequestMap()
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withIds(audienceTargetId))
                        .withFieldNames(AudienceTargetFieldEnum.ID, AudienceTargetFieldEnum.STATE));

        assertThat("Получен один объект", response.getAudienceTargets(), hasSize(1));
    }

}
