package ru.yandex.autotests.direct.api.audiencetargets.production;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetsPort;
import com.yandex.direct.api.v5.audiencetargets.GetRequest;
import com.yandex.direct.api.v5.audiencetargets.GetResponse;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.test.units.UnitsHeaderTester;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTestDataConsumer;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTestDataInjector;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static ru.yandex.autotests.directapi.test.units.UnitsHeaderUtil.getUnitsHeader;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Smoke-тесты на проверку некоторых методов на production окружении
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-66636")
@Features(ApiFeatures.PRODUCTION)
@Description("Production smoke test: AudienceTargets. Проверка списания баллов.")
public class UnitsAudienceTargetsProdTest implements UnitsWithdrawalTestDataConsumer {

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final UnitsHeaderTester tester = UnitsHeaderTester.newInstance(api);

    @Rule
    public Trashman trasher = new Trashman(api);

    private Function<String, String> serviceCallFunction = getUnitsHeader(
            (String clientLogin) -> {
                AudienceTargetsPort port = api.userSteps.soapClientV5().audienceTargetsService(clientLogin);
                GetResponse response = port.get((GetRequest) new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(0L)).getBean());
                assumeThat("Получен пустой ответ", response.getAudienceTargets(), empty());

                return port;
            }
    );

    private String operatorLogin;
    private String clientLogin;
    private String useOperatorUnits;
    private int unitsDelta;
    private Collection<String> expectedUnitsWithdrawLogins;
    private Collection<String> expectedUnitsKeepLogins;

    @BeforeClass
    public static void init() {
        tester.init();
    }

    @Before
    public void reset() {
        UnitsWithdrawalTestDataInjector.newInstance().injectTheSimplestTestCaseData(this);
    }

    @Test
    public void testUnitsWithdrawal() {
        Supplier<String> serviceCall = () -> serviceCallFunction.apply(clientLogin);

        tester.test(serviceCall, operatorLogin, clientLogin, useOperatorUnits);
    }

    @AfterClass
    public static void shutdown() {
        tester.shutdown();
    }

    @Override
    public void setDescription(String description) {
        // no need
    }

    @Override
    public void setOperatorLogin(String operatorLogin) {
        this.operatorLogin = operatorLogin;
    }

    @Override
    public void setClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
    }

    @Override
    public void setUseOperatorUnits(String useOperatorUnits) {
        this.useOperatorUnits = useOperatorUnits;
    }

    @Override
    public void setUnitsDelta(int unitsDelta) {
        this.unitsDelta = unitsDelta;
    }

    @Override
    public void setExpectedUnitsWithdrawLogins(Collection<String> expectedUnitsWithdrawLogins) {
        this.expectedUnitsWithdrawLogins = expectedUnitsWithdrawLogins;
    }

    @Override
    public void setExpectedUnitsKeepLogins(Collection<String> expectedUnitsKeepLogins) {
        this.expectedUnitsKeepLogins = expectedUnitsKeepLogins;
    }

}
