package ru.yandex.autotests.direct.api.audiencetargets.resume;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.RESUME)
@Description("Проверка ограничения поля Ids")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class ResumeAudienceTargetsIdsLimitTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET36;
    private static Long targetId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        targetId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);
    }

    @Test
    public void moreThanMaxIdsInSelectionCriteria() {
        Long[] ids = new Long[ResumeRequestMap.MAX_AMOUNT_OF_IDS_IN_RESUME_REQUEST + 1];
        Arrays.fill(ids, targetId);
        api.userSteps.audienceTargetsSteps().expectErrorOnAudienceTargetsResume(
                new ResumeRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(ids)
                        ),
                new Api5Error(9300,
                        Api5ErrorDetailsJava.MAX_OBJECTS,
                        ResumeRequestMap.MAX_AMOUNT_OF_IDS_IN_RESUME_REQUEST)
        );
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void maxIdsInSelectionCriteria() {
        api.userSteps.audienceTargetsSteps().suspend(targetId);
        Long[] ids = new Long[ResumeRequestMap.MAX_AMOUNT_OF_IDS_IN_RESUME_REQUEST];
        Arrays.fill(ids, targetId);
        ExpectedResult[] results =
                new ExpectedResult[ResumeRequestMap.MAX_AMOUNT_OF_IDS_IN_RESUME_REQUEST];
        Arrays.fill(results, ExpectedResult.warnings(
                new Notification(10000, Api5ErrorDetails.RETARGETING_LISTS_ID_SHOULD_BE_ONCE_IN_REQUEST)));
        api.userSteps.audienceTargetsSteps().shouldGetResultOnResume(
                new ResumeRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(ids)
                        ),
                results
        );
    }
}
