package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.RESUME)
@Description("Проверка ограничения поля Ids")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class SetBidsAudienceTargetLimitTest {
    private static Long pid;
    private static Long cid;
    long minimumBid = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue();
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET45;
    private static Long targetId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        targetId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void moreThanMaxBidsWithId() {
        AudienceTargetSetBidsItemMap[] bids = new AudienceTargetSetBidsItemMap[SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_ID + 1];
        Arrays.fill(bids,
                new AudienceTargetSetBidsItemMap()
                        .withId(targetId)
                        .withContextBid(minimumBid));
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                new SetBidsRequestMap()
                        .withBids(bids),
                new Api5Error(9300,
                        Api5ErrorDetailsJava.AUDIENCE_TARGETS_SET_BIDS_LIMIT_EXCEEDED,
                        SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_ID)
        );
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void maxBidsWithId() {
        AudienceTargetSetBidsItemMap[] bids = new AudienceTargetSetBidsItemMap[SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_ID];
        Arrays.fill(bids,
                new AudienceTargetSetBidsItemMap()
                        .withId(targetId)
                        .withContextBid(minimumBid));
        SetBidsExpectedResult[] expectedResults = new SetBidsExpectedResult[SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_ID];
        Arrays.fill(expectedResults,
                SetBidsExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)));
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(bids),
                expectedResults
        );
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void moreThanMaxBidsWithAdGroupId() {
        AudienceTargetSetBidsItemMap[] bids = new AudienceTargetSetBidsItemMap[SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_AD_GROUP_ID + 1];
        Arrays.fill(bids,
                new AudienceTargetSetBidsItemMap()
                        .withAdGroupId(pid)
                        .withContextBid(minimumBid));
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                new SetBidsRequestMap()
                        .withBids(bids),
                new Api5Error(9300,
                        Api5ErrorDetails.AUDIENCE_TARGETS_SET_BIDS_AD_GROUP_LIMIT_EXCEEDED,
                        SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_AD_GROUP_ID)
        );
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void maxBidsWithAdGroupId() {
        AudienceTargetSetBidsItemMap[] bids = new AudienceTargetSetBidsItemMap[SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_AD_GROUP_ID];
        Arrays.fill(bids,
                new AudienceTargetSetBidsItemMap()
                        .withAdGroupId(pid)
                        .withContextBid(minimumBid));
        SetBidsExpectedResult[] expectedResults = new SetBidsExpectedResult[SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_AD_GROUP_ID];
        Arrays.fill(expectedResults,
                SetBidsExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)));
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(bids),
                expectedResults
        );
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void moreThanMaxBidsWithCampaignId() {
        AudienceTargetSetBidsItemMap[] bids = new AudienceTargetSetBidsItemMap[SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_CAMPAIGN_ID + 1];
        Arrays.fill(bids,
                new AudienceTargetSetBidsItemMap()
                        .withCampaignId(cid)
                        .withContextBid(minimumBid));
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                new SetBidsRequestMap()
                        .withBids(bids),
                new Api5Error(9300,
                        Api5ErrorDetails.AUDIENCE_TARGETS_SET_BIDS_CAMPAIGN_LIMIT_EXCEEDED,
                        SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_CAMPAIGN_ID)
        );
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void maxBidsWithCampaignId() {
        AudienceTargetSetBidsItemMap[] bids = new AudienceTargetSetBidsItemMap[SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_CAMPAIGN_ID];
        Arrays.fill(bids,
                new AudienceTargetSetBidsItemMap()
                        .withCampaignId(cid)
                        .withContextBid(minimumBid));
        SetBidsExpectedResult[] expectedResults = new SetBidsExpectedResult[SetBidsRequestMap.MAX_AMOUNT_OF_BIDS_WITH_CAMPAIGN_ID];
        Arrays.fill(expectedResults,
                SetBidsExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)));
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(bids),
                expectedResults
        );
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }
}
