package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetGetItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by lightelfik on 06/07/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Проверка успешных сценариев установки ставок с разными типами id'шников")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class SetBidsAudienceTargetsSuccessTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET46;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long pid;
    private static Long cid;
    private static List<Long> audienceTargetsIds;
    private static Long minBid = MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        List<Long> goalIds =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        Long retargetingListsId1 = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0));
        Long retargetingListsId2 = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(1));
        audienceTargetsIds = api.userSteps.audienceTargetsSteps().add(
                new AddRequestMap().withAudienceTargets(new AudienceTargetAddItemMap()
                                .withRetargetingListId(retargetingListsId1)
                                .withAdGroupId(pid)
                                .withContextBid(MoneyCurrency.get(User.get(LOGIN)
                                        .getCurrency()).getLongMinPrice().longValue()),
                        new AudienceTargetAddItemMap()
                                .withRetargetingListId(retargetingListsId2)
                                .withAdGroupId(pid)
                                .withContextBid(MoneyCurrency.get(User.get(LOGIN)
                                        .getCurrency()).getLongMinPrice().longValue())
                )
        );
        assumeThat("создались два условия нацеливания", audienceTargetsIds.size(), equalTo(2));
    }

    @Test
    public void testSuccessId() {
        int random = RandomUtils.getRandomInteger(1, 100);
        long bid = minBid + random * 10000;
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(
                        new AudienceTargetSetBidsItemMap()
                                .withId(audienceTargetsIds.get(0))
                                .withContextBid(bid)
                ), SetBidsExpectedResult.successWithId());
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.CONTEXT_BID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(audienceTargetsIds.get(0)))
        );
        assertThat("ставка изменилась", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                        .withContextBid(bid).getBean())
        ));
    }

    @Test
    public void testSuccessAdGroupId() {
        int random = RandomUtils.getRandomInteger(1, 100);
        long bid = minBid + random * 10000;
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(
                        new AudienceTargetSetBidsItemMap()
                                .withAdGroupId(pid)
                                .withContextBid(bid)
                ), SetBidsExpectedResult.successWithAdGroupId());
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.CONTEXT_BID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withAdGroupIds(pid))
        );
        assertThat("ставки изменились", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                                .withContextBid(bid).getBean(),
                        (AudienceTargetGetItem) new AudienceTargetGetItemMap()
                                .withContextBid(bid).getBean())
        ));
    }

    @Test
    public void testSuccessCampaignId() {
        int random = RandomUtils.getRandomInteger(1, 100);
        long bid = minBid + random * 10000;
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(
                        new AudienceTargetSetBidsItemMap()
                                .withCampaignId(cid)
                                .withContextBid(bid)
                ), SetBidsExpectedResult.successWithCampaignId());
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.CONTEXT_BID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withCampaignIds(cid))
        );
        assertThat("ставки изменились", targets, beanDiffer(
                Arrays.asList((AudienceTargetGetItem) new AudienceTargetGetItemMap()
                                .withContextBid(bid).getBean(),
                        (AudienceTargetGetItem) new AudienceTargetGetItemMap()
                                .withContextBid(bid).getBean())
        ));
    }

}
